/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.registry;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.ElementalCraft;

public class RegistryHelper {
    private RegistryHelper() {
    }

    public static <T> void register(IForgeRegistry<T> reg, T thing, ResourceLocation name) {
        reg.register(name, thing);
    }

    public static <T> void register(IForgeRegistry<T> reg, T thing, String name) {
        RegistryHelper.register(reg, thing, ElementalCraft.createRL(name));
    }

    public static <T> void register(IForgeRegistry<T> reg, T thing, RegistryObject<?> object) {
        RegistryHelper.register(reg, thing, object.getId());
    }

    public static <T> Supplier<RegistryBuilder<T>> builder(UnaryOperator<RegistryBuilder<T>> mapper) {
        return () -> (RegistryBuilder)mapper.apply(new RegistryBuilder());
    }
}

