/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.nbt.NBTHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.Spells;

public class SpellHelper {
    private SpellHelper() {
    }

    public static Spell getSpell(ItemStack stack) {
        return SpellHelper.getSpellFromTag((Tag)NBTHelper.getECTag(stack));
    }

    public static void setSpell(ItemStack stack, Spell spell) {
        CompoundTag nbt = NBTHelper.getOrCreateECTag(stack);
        nbt.m_128359_("spell", spell.getKey().toString());
    }

    public static void removeSpell(ItemStack stack, Spell spell) {
        ListTag list = SpellHelper.getSpellList(stack);
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = (CompoundTag)list.get(i);
                if (!tag.m_128461_("spell").equals(spell.getKey().toString())) continue;
                int count = tag.m_128451_("count");
                if (count > 1) {
                    tag.m_128405_("count", count - 1);
                } else {
                    SpellHelper.moveSelected(stack, -1);
                    list.remove(i);
                    if (list.isEmpty()) {
                        SpellHelper.setSpell(stack, (Spell)Spells.NONE.get());
                    }
                }
                return;
            }
        }
    }

    public static ListTag getOrCreateSpellList(ItemStack stack) {
        CompoundTag nbt = NBTHelper.getOrCreateECTag(stack);
        ListTag list = nbt.m_128437_("spell_list", 10);
        if (!nbt.m_128441_("spell_list")) {
            nbt.m_128365_("spell_list", (Tag)list);
        }
        return list;
    }

    public static void forEachSpell(ItemStack stack, ObjIntConsumer<Spell> consumer) {
        ListTag list = SpellHelper.getSpellList(stack);
        if (list != null && !list.isEmpty()) {
            list.forEach(t -> {
                CompoundTag tag = (CompoundTag)t;
                consumer.accept(SpellHelper.getSpellFromTag((Tag)tag), tag.m_128451_("count"));
            });
        }
    }

    public static List<Pair<Spell, Integer>> getSpellsAsMap(ItemStack stack) {
        ListTag list = SpellHelper.getSpellList(stack);
        if (list != null && !list.isEmpty()) {
            ArrayList<Pair<Spell, Integer>> value = new ArrayList<Pair<Spell, Integer>>(list.size());
            list.forEach(t -> {
                CompoundTag tag = (CompoundTag)t;
                value.add(new Pair((Object)SpellHelper.getSpellFromTag((Tag)tag), (Object)tag.m_128451_("count")));
            });
            return value;
        }
        return Collections.emptyList();
    }

    public static void copySpells(ItemStack source, ItemStack target) {
        ListTag list = SpellHelper.getSpellList(source);
        Spell spell = SpellHelper.getSpell(source);
        if (list != null && !list.isEmpty()) {
            NBTHelper.getOrCreateECTag(target).m_128365_("spell_list", (Tag)list.m_6426_());
        }
        if (spell.isValid()) {
            SpellHelper.setSpell(target, spell);
        }
    }

    public static int getSpellCount(ItemStack stack) {
        ListTag list = SpellHelper.getSpellList(stack);
        if (list != null && !list.isEmpty()) {
            return list.stream().mapToInt(t -> ((CompoundTag)t).m_128451_("count")).sum();
        }
        return 0;
    }

    public static void addSpell(ItemStack stack, Spell spell) {
        ListTag list = SpellHelper.getOrCreateSpellList(stack);
        for (Tag value : list) {
            CompoundTag tag;
            if (!(value instanceof CompoundTag) || !SpellHelper.isSpellInTag((Tag)(tag = (CompoundTag)value), spell)) continue;
            tag.m_128405_("count", tag.m_128451_("count") + 1);
            return;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("spell", spell.getKey().toString());
        tag.m_128405_("count", 1);
        list.add((Object)tag);
        if (list.size() == 1) {
            SpellHelper.setSpell(stack, spell);
        }
    }

    public static int getSelected(ItemStack stack) {
        ListTag list = SpellHelper.getSpellList(stack);
        Spell spell = SpellHelper.getSpell(stack);
        if (list != null && !list.isEmpty()) {
            return IntStream.range(0, list.size()).filter(j -> SpellHelper.isSpellInTag(list.get(j), spell)).findFirst().orElse(0);
        }
        return 0;
    }

    public static void setSelected(ItemStack stack, int i) {
        ListTag list = SpellHelper.getSpellList(stack);
        if (list != null && !list.isEmpty()) {
            if (i < 0) {
                i = list.size() - 1;
            } else if (i >= list.size()) {
                i = 0;
            }
            SpellHelper.setSpell(stack, SpellHelper.getSpellFromTag(list.get(i)));
        }
    }

    public static void moveSelected(ItemStack stack, int i) {
        SpellHelper.setSelected(stack, SpellHelper.getSelected(stack) + i);
    }

    @Nullable
    private static ListTag getSpellList(ItemStack stack) {
        CompoundTag nbt = NBTHelper.getECTag(stack);
        if (nbt != null && nbt.m_128441_("spell_list")) {
            return nbt.m_128437_("spell_list", 10);
        }
        return null;
    }

    private static Spell getSpellFromTag(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)nbt;
            return (Spell)Spells.REGISTRY.get().getValue(new ResourceLocation(compoundTag.m_128461_("spell")));
        }
        return (Spell)Spells.NONE.get();
    }

    private static boolean isSpellInTag(Tag nbt, Spell spell) {
        if (nbt instanceof CompoundTag && ((CompoundTag)nbt).m_128441_("spell")) {
            return ((CompoundTag)nbt).m_128461_("spell").equals(spell.getKey().toString());
        }
        return false;
    }

    public static Spell randomSpell(RandomSource rand) {
        return SpellHelper.randomSpell(Spells.REGISTRY.get().getValues(), rand);
    }

    public static Spell randomSpell(ElementType type, RandomSource rand) {
        return SpellHelper.randomSpell(Spells.REGISTRY.get().getValues().stream().filter(spell -> spell.getElementType() == type && spell.isValid()).collect(Collectors.toList()), rand);
    }

    public static Spell randomSpell(Collection<Spell> spells, RandomSource rand) {
        List<Spell> list = spells.stream().filter(Spell::isValid).toList();
        int roll = rand.m_188503_(list.stream().mapToInt(Spell::getWeight).sum());
        for (Spell spell : list) {
            if ((roll -= spell.getWeight()) >= 0) continue;
            return spell;
        }
        return list.get(list.size() - 1);
    }

    public static Spell getSpellInUse(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6117_()) {
            return SpellHelper.getSpell(livingEntity.m_21211_());
        }
        return (Spell)Spells.NONE.get();
    }
}

