/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.air;

import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import sirttas.elementalcraft.spell.Spell;

public class EnderStrikeSpell
extends Spell {
    public static final String NAME = "ender_strike";

    public EnderStrikeSpell(ResourceKey<Spell> key) {
        super(key);
    }

    @Override
    @Nonnull
    public InteractionResult castOnEntity(@Nonnull Entity caster, @Nonnull Entity target) {
        Vec3 newPos = target.m_20182_().m_82549_(target.m_20154_().m_82548_().m_82541_());
        if (MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)new Event(caster, newPos.f_82479_, newPos.f_82480_ + 0.5, newPos.f_82481_))) {
            return InteractionResult.SUCCESS;
        }
        if (caster instanceof LivingEntity) {
            LivingEntity livingSender = (LivingEntity)caster;
            livingSender.m_6021_(newPos.f_82479_, newPos.f_82480_ + 0.5, newPos.f_82481_);
            livingSender.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
            livingSender.m_9236_().m_6263_(null, livingSender.f_19854_, livingSender.f_19855_, livingSender.f_19856_, SoundEvents.f_11852_, livingSender.m_5720_(), 1.0f, 1.0f);
            livingSender.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            livingSender.m_6674_(InteractionHand.MAIN_HAND);
            if (livingSender instanceof Player) {
                Player playerSender = (Player)livingSender;
                playerSender.m_5706_(target);
                playerSender.m_36334_();
            } else {
                livingSender.m_7327_(target);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        Vec3 pos = caster.m_20182_();
        return caster.m_9236_().m_45976_(LivingEntity.class, new AABB(pos, pos.m_82520_(1.0, 1.0, 1.0)).m_82400_((double)this.getRange(caster))).stream().filter(Enemy.class::isInstance).min(Comparator.comparingDouble(e -> pos.m_82554_(e.m_20182_()))).map(e -> this.castOnEntity(caster, (Entity)e)).orElse(InteractionResult.PASS);
    }

    public static class Event
    extends EntityTeleportEvent {
        public Event(Entity entity, double targetX, double targetY, double targetZ) {
            super(entity, targetX, targetY, targetZ);
        }
    }
}

