/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.modintegration.theoneprobe;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class OneProbeDataProvider
implements IProbeInfoProvider {
    static final OneProbeDataProvider INSTANCE = new OneProbeDataProvider();
    private static final ResourceLocation INFO_PROVIDER_ID = new ResourceLocation("enderchests", "default");
    private static final ResourceLocation ELEMENT_ID = new ResourceLocation("enderchests", "element");

    public ResourceLocation getID() {
        return INFO_PROVIDER_ID;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        BlockEntity tile;
        if (blockState.m_60734_() instanceof BlockEnderChest && (tile = world.m_7702_(data.getPos())) instanceof TileEntityEnderChest) {
            probeInfo.element((IElement)new ElementChestInfo((TileEntityEnderChest)tile, !mode.equals((Object)ProbeMode.NORMAL)));
        }
    }

    private static class ElementChestInfo
    implements IElement {
        static final ResourceLocation COMPARATOR = new ResourceLocation("textures/item/comparator.png");
        final CompoundTag data;
        final List<Component> lines = new ArrayList<Component>();
        private boolean renderIcon;

        private ElementChestInfo(TileEntityEnderChest chest, boolean showDetails) {
            this.data = new CompoundTag();
            this.data.m_128365_("basic", (Tag)ChestInfoHelper.packHUDBasic(chest));
        }

        private ElementChestInfo(CompoundTag data) {
            if (data == null || data.m_128456_()) {
                this.data = new CompoundTag();
                return;
            }
            this.data = data;
            if (data.m_128441_("basic")) {
                ChestInfoHelper.unpackHUDInfo(this.lines, data.m_128437_("basic", 8));
            }
        }

        public void render(PoseStack matrixStack, int x, int y) {
            int indent = this.lines.size() - 1;
            int counter = 0;
            for (Component line : this.lines) {
                ElementTextRender.render((Component)line, (PoseStack)matrixStack, (int)(counter < indent ? x : x + 10), (int)y);
                y += 10;
                ++counter;
            }
        }

        public int getWidth() {
            int width = 0;
            for (Component line : this.lines) {
                width = Math.max(width, ElementTextRender.getWidth((Component)line));
            }
            return width;
        }

        public int getHeight() {
            return 10 + (this.lines.size() - 1) * 10;
        }

        public void toBytes(FriendlyByteBuf buffer) {
            buffer.m_130079_(this.data);
        }

        public ResourceLocation getID() {
            return ELEMENT_ID;
        }
    }

    static class ElementFactoryChestInfo
    implements IElementFactory {
        ElementFactoryChestInfo() {
        }

        public IElement createElement(FriendlyByteBuf buffer) {
            return new ElementChestInfo(buffer.m_130260_());
        }

        public ResourceLocation getId() {
            return ELEMENT_ID;
        }
    }
}

