/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.EntangledConfig;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EntangledBlock
extends BaseBlock
implements EntityHoldingBlock {
    public static final BooleanProperty ON = BooleanProperty.m_61465_((String)"on");

    public EntangledBlock() {
        super(true, BlockProperties.create((Material)new Material.Builder(MaterialColor.f_76362_).m_76354_().m_76359_()).sound(SoundType.f_56742_).destroyTime(1.0f).explosionResistance(2.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (level.f_46443_) {
            return BaseBlock.InteractionFeedback.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_() && stack.m_41619_() && ((Boolean)state.m_61143_((Property)ON)).booleanValue()) {
            ((EntangledBlockEntity)level.m_7702_(pos)).bind(null, null);
            player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.unbind").color(ChatFormatting.YELLOW).get(), true);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(false)));
            return BaseBlock.InteractionFeedback.SUCCESS;
        }
        if (stack.m_41720_() == Entangled.item) {
            CompoundTag compound = stack.m_41783_();
            if (compound == null || !compound.m_128471_("bound")) {
                player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.no_selection").color(ChatFormatting.RED).get(), true);
            } else {
                BlockPos pos2 = new BlockPos(compound.m_128451_("boundx"), compound.m_128451_("boundy"), compound.m_128451_("boundz"));
                if (pos2.equals((Object)pos)) {
                    player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.self").color(ChatFormatting.RED).get(), true);
                } else {
                    if (!((Boolean)level.m_8055_(pos).m_61143_((Property)ON)).booleanValue()) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(true)));
                    }
                    EntangledBlockEntity tile = (EntangledBlockEntity)level.m_7702_(pos);
                    if (compound.m_128461_("dimension").equals(level.m_46472_().m_135782_().toString())) {
                        if (EntangledConfig.maxDistance.get() == -1 || pos.m_123314_((Vec3i)pos2, (double)EntangledConfig.maxDistance.get().intValue() + 0.5)) {
                            tile.bind(pos2, compound.m_128461_("dimension"));
                            player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.bind").color(ChatFormatting.YELLOW).get(), true);
                        } else {
                            player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.too_far").color(ChatFormatting.RED).get(), true);
                        }
                    } else if (EntangledConfig.allowDimensional.get().booleanValue()) {
                        tile.bind(pos2, compound.m_128461_("dimension"));
                        player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.bind").color(ChatFormatting.YELLOW).get(), true);
                    } else {
                        player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.wrong_dimension").color(ChatFormatting.RED).get(), true);
                    }
                }
            }
            return BaseBlock.InteractionFeedback.SUCCESS;
        }
        return BaseBlock.InteractionFeedback.PASS;
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return new EntangledBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ON});
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ON) != false ? Shapes.m_83040_() : Shapes.m_83144_();
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        String key = EntangledConfig.allowDimensional.get().booleanValue() ? (EntangledConfig.maxDistance.get() == -1 ? "infinite_other_dimension" : "ranged_other_dimension") : (EntangledConfig.maxDistance.get() == -1 ? "infinite_same_dimension" : "ranged_same_dimension");
        MutableComponent maxDistance = TextComponents.string((String)Integer.toString(EntangledConfig.maxDistance.get())).color(ChatFormatting.GOLD).get();
        info.accept((Component)TextComponents.translation((String)("entangled.entangled_block.info." + key), (Object[])new Object[]{maxDistance}).color(ChatFormatting.AQUA).get());
        CompoundTag tag = stack.m_41784_().m_128469_("tileData");
        if (tag.m_128441_("bound") && tag.m_128471_("bound")) {
            int x = tag.m_128451_("boundx");
            int y = tag.m_128451_("boundy");
            int z = tag.m_128451_("boundz");
            MutableComponent dimension = TextComponents.dimension((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension")))).color(ChatFormatting.GOLD).get();
            MutableComponent name = TextComponents.blockState((BlockState)Block.m_49803_((int)tag.m_128451_("blockstate"))).color(ChatFormatting.GOLD).get();
            MutableComponent xText = TextComponents.string((String)Integer.toString(x)).color(ChatFormatting.GOLD).get();
            MutableComponent yText = TextComponents.string((String)Integer.toString(y)).color(ChatFormatting.GOLD).get();
            MutableComponent zText = TextComponents.string((String)Integer.toString(z)).color(ChatFormatting.GOLD).get();
            info.accept((Component)TextComponents.translation((String)"entangled.entangled_block.info.bound", (Object[])new Object[]{name, xText, yText, zText, dimension}).color(ChatFormatting.YELLOW).get());
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        CompoundTag compound = stack.m_41784_().m_128469_("tileData");
        if (compound.m_128471_("bound")) {
            Player player = context.m_43723_();
            BlockPos pos = context.m_8083_();
            BlockPos pos2 = new BlockPos(compound.m_128451_("boundx"), compound.m_128451_("boundy"), compound.m_128451_("boundz"));
            if (compound.m_128461_("dimension").equals(context.m_43725_().m_46472_().m_135782_().toString())) {
                if (EntangledConfig.maxDistance.get() >= 0 && !pos.m_123314_((Vec3i)pos2, (double)EntangledConfig.maxDistance.get().intValue() + 0.5)) {
                    if (player != null && !context.m_43725_().f_46443_) {
                        player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.too_far").color(ChatFormatting.RED).get(), true);
                    }
                    return null;
                }
            } else if (!EntangledConfig.allowDimensional.get().booleanValue()) {
                if (player != null && !context.m_43725_().f_46443_) {
                    player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.wrong_dimension").color(ChatFormatting.RED).get(), true);
                }
                return null;
            }
            return (BlockState)this.m_49966_().m_61124_((Property)ON, (Comparable)Boolean.valueOf(true));
        }
        return this.m_49966_();
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity entity = world.m_7702_(pos);
        return entity instanceof EntangledBlockEntity ? ((EntangledBlockEntity)entity).getAnalogOutputSignal() : 0;
    }

    public boolean m_7899_(BlockState p_60571_) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        BlockEntity entity = world.m_7702_(pos);
        return entity instanceof EntangledBlockEntity ? ((EntangledBlockEntity)entity).getRedstoneSignal(direction) : 0;
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        BlockEntity entity = world.m_7702_(pos);
        return entity instanceof EntangledBlockEntity ? ((EntangledBlockEntity)entity).getDirectRedstoneSignal(direction) : 0;
    }
}

