/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftblibrary.icon.Icon;
import java.util.HashMap;
import java.util.Map;

public class WaypointType {
    public static final Map<String, WaypointType> TYPES = new HashMap<String, WaypointType>();
    public static final WaypointType DEFAULT = WaypointType.add("default").outsideIcon("ftbchunks:textures/waypoint_default_outside.png").canChangeColor();
    public static final WaypointType DEATH = WaypointType.add("death");
    public final String id;
    public Icon icon;
    public Icon outsideIcon;
    public boolean canChangeColor;

    public static WaypointType add(String id) {
        WaypointType type = new WaypointType(id);
        TYPES.put(id, type);
        return type;
    }

    private WaypointType(String i) {
        this.id = i;
        this.outsideIcon = this.icon = Icon.getIcon((String)("ftbchunks:textures/waypoint_" + this.id + ".png"));
        this.canChangeColor = false;
    }

    public WaypointType icon(String t) {
        this.icon = Icon.getIcon((String)t);
        return this;
    }

    public WaypointType outsideIcon(String t) {
        this.outsideIcon = Icon.getIcon((String)t);
        return this;
    }

    public WaypointType canChangeColor() {
        this.canChangeColor = true;
        return this;
    }
}

