/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.util.EnergyArmorMaterial;
import dev.ftb.mods.ftbic.util.EnergyItemHandler;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MechanicalElytraItem
extends ArmorItem
implements EnergyItemHandler {
    public MechanicalElytraItem() {
        super((ArmorMaterial)EnergyArmorMaterial.ELYTRA, EquipmentSlot.CHEST, new Item.Properties().m_41491_(FTBIC.TAB));
    }

    public void damageEnergyItem(ItemStack stack, double amount) {
        double energy = this.getEnergy(stack);
        double e = Math.min(energy, amount);
        this.setEnergy(stack, energy - e);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    @Override
    public double getEnergyCapacity(ItemStack stack) {
        return ((EnergyArmorMaterial)this.f_40379_).capacity.get();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot s) {
        return ImmutableMultimap.of();
    }

    public boolean m_6832_(ItemStack stack, ItemStack item) {
        return false;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        if (this.m_220152_(tab)) {
            list.add((Object)new ItemStack((ItemLike)this));
            ItemStack full = new ItemStack((ItemLike)this);
            this.setEnergyRaw(full, this.getEnergyCapacity(full));
            list.add((Object)full);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add(FTBICUtils.energyTooltip(stack, this));
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.getEnergy(stack) >= (Double)FTBICConfig.EQUIPMENT.ARMOR_FLIGHT_ENERGY.get();
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (!entity.f_19853_.f_46443_) {
            this.damageEnergyItem(stack, (Double)FTBICConfig.EQUIPMENT.ARMOR_FLIGHT_ENERGY.get());
        }
        if (flightTicks >= 3 && entity.m_6047_()) {
            Vec3 m = entity.m_20184_();
            double d = Math.max(Math.abs(m.f_82480_), Math.max(Math.abs(m.f_82479_), Math.abs(m.f_82481_)));
            d = Math.min(d, 1.0);
            entity.m_20256_(m.m_82542_(d *= 0.91, d, d));
            this.damageEnergyItem(stack, (Double)FTBICConfig.EQUIPMENT.ARMOR_FLIGHT_STOP.get());
        } else if (flightTicks >= 5 && entity.m_20142_()) {
            Vec3 v = entity.m_20154_();
            double d0 = 1.5;
            double d1 = 0.1;
            Vec3 m = entity.m_20184_();
            entity.m_20256_(m.m_82520_(v.f_82479_ * d1 + (v.f_82479_ * d0 - m.f_82479_) * 0.5, v.f_82480_ * d1 + (v.f_82480_ * d0 - m.f_82480_) * 0.5, v.f_82481_ * d1 + (v.f_82481_ * d0 - m.f_82481_) * 0.5));
            this.damageEnergyItem(stack, (Double)FTBICConfig.EQUIPMENT.ARMOR_FLIGHT_BOOST.get());
        }
        return true;
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if ((Double)FTBICConfig.EQUIPMENT.MECHANICAL_ELYTRA_RECHARGE.get() > 0.0 && !level.m_5776_() && !player.m_21255_() && level.m_46461_() && level.m_45527_(new BlockPos(player.m_20299_(1.0f)))) {
            this.insertEnergy(stack, (Double)FTBICConfig.EQUIPMENT.MECHANICAL_ELYTRA_RECHARGE.get(), false);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("Energy");
    }

    public int m_142158_(ItemStack stack) {
        return Math.round((float)Mth.m_14008_((double)(this.getEnergy(stack) / this.getEnergyCapacity(stack) * 13.0), (double)0.0, (double)13.0));
    }

    public int m_142159_(ItemStack stack) {
        return -65536;
    }
}

