/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.SNBTNet;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.net.FTBUltimineNet;
import dev.ftb.mods.ftbultimine.net.SyncConfigFromServerPacket;
import java.nio.file.Path;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SyncConfigToServerPacket
extends BaseC2SMessage {
    private final SNBTCompoundTag config;

    public SyncConfigToServerPacket(SNBTCompoundTag config) {
        this.config = config;
    }

    public SyncConfigToServerPacket(FriendlyByteBuf buf) {
        this.config = SNBTNet.readCompound((FriendlyByteBuf)buf);
    }

    public MessageType getType() {
        return FTBUltimineNet.SYNC_CONFIG_TO_SERVER;
    }

    public void write(FriendlyByteBuf buf) {
        SNBTNet.writeCompound((FriendlyByteBuf)buf, (SNBTCompoundTag)this.config);
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer sp;
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).m_20310_(2)) {
            MinecraftServer server = sp.m_20194_();
            FTBUltimine.LOGGER.info("Server config updated from client by player {}", (Object)sp.m_7755_().getString());
            FTBUltimineServerConfig.CONFIG.read(this.config);
            FTBUltimineServerConfig.clearTagCache();
            Path file = server.m_129843_(ConfigUtil.SERVER_CONFIG_DIR).resolve(FTBUltimineServerConfig.CONFIG.key + ".snbt");
            FTBUltimineServerConfig.CONFIG.save(file);
            for (ServerPlayer player2 : server.m_6846_().m_11314_()) {
                if (sp.m_20148_().equals(player2.m_20148_())) continue;
                new SyncConfigFromServerPacket(this.config).sendTo(player2);
            }
        }
    }
}

