/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common;

import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common.ItemStackToListCache;
import dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common.WrappedQuest;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class WrappedQuestCache {
    private final List<WrappedQuest> wrappedQuestsCache = new ArrayList<WrappedQuest>();
    private final ItemStackToListCache<WrappedQuest> inputCache = new ItemStackToListCache();
    private final ItemStackToListCache<WrappedQuest> outputCache = new ItemStackToListCache();
    private boolean needsRefresh = true;

    public List<WrappedQuest> getCachedItems() {
        if (this.needsRefresh) {
            this.rebuildWrappedQuestCache();
            this.needsRefresh = false;
        }
        return this.wrappedQuestsCache;
    }

    public void clear() {
        this.needsRefresh = true;
        this.inputCache.clear();
        this.outputCache.clear();
    }

    private void rebuildWrappedQuestCache() {
        this.wrappedQuestsCache.clear();
        if (ClientQuestFile.exists()) {
            for (ChapterGroup group : ClientQuestFile.INSTANCE.chapterGroups) {
                for (Chapter chapter : group.chapters) {
                    for (Quest quest : chapter.getQuests()) {
                        List<Reward> rewards;
                        if (!ClientQuestFile.INSTANCE.self.canStartTasks(quest) || quest.rewards.isEmpty() || quest.disableJEI.get(ClientQuestFile.INSTANCE.defaultQuestDisableJEI) || (rewards = quest.rewards.stream().filter(reward -> reward.getAutoClaimType() != RewardAutoClaim.INVISIBLE && reward.getIngredient() != null).toList()).isEmpty()) continue;
                        this.wrappedQuestsCache.add(new WrappedQuest(quest, rewards));
                    }
                }
            }
        }
    }

    public List<WrappedQuest> findQuestsWithInput(ItemStack stack) {
        return this.inputCache.getList(stack, k -> this.getCachedItems().stream().filter(q -> q.hasInput(stack)).toList());
    }

    public List<WrappedQuest> findQuestsWithOutput(ItemStack stack) {
        return this.outputCache.getList(stack, k -> this.getCachedItems().stream().filter(q -> q.hasOutput(stack)).toList());
    }
}

