/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client.loader;

import com.buuz135.functionalstorage.block.FramedDrawerBlock;
import com.buuz135.functionalstorage.client.model.FramedDrawerModelData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.common.util.ConcatenatedListView;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FramedModel
implements IUnbakedGeometry<FramedModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ImmutableMap<String, BlockModel> children;
    private final ImmutableList<String> itemPasses;
    private final boolean logWarning;

    public FramedModel(ImmutableMap<String, BlockModel> children, ImmutableList<String> itemPasses) {
        this(children, itemPasses, false);
    }

    private FramedModel(ImmutableMap<String, BlockModel> children, ImmutableList<String> itemPasses, boolean logWarning) {
        this.children = children;
        this.itemPasses = itemPasses;
        this.logWarning = logWarning;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        if (this.logWarning) {
            LOGGER.warn("Model \"" + modelLocation + "\" is using the deprecated \"parts\" field in its composite model instead of \"children\". This field will be removed in 1.20.");
        }
        Material particleLocation = context.getMaterial("particle");
        TextureAtlasSprite particle = spriteGetter.apply(particleLocation);
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(rootTransform), modelState.m_7538_());
        }
        ImmutableMap.Builder bakedPartsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.children.entrySet()) {
            String name = (String)entry.getKey();
            if (!context.isComponentVisible(name, true)) continue;
            BlockModel model = (BlockModel)entry.getValue();
            bakedPartsBuilder.put((Object)name, (Object)model.m_111449_(bakery, model, spriteGetter, modelState, modelLocation, true));
        }
        ImmutableMap bakedParts = bakedPartsBuilder.build();
        ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
        for (String name : this.itemPasses) {
            BakedModel model = (BakedModel)bakedParts.get((Object)name);
            if (model == null) {
                throw new IllegalStateException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
            }
            itemPassesBuilder.add((Object)model);
        }
        return new Baked(context.isGui3d(), context.useBlockLight(), context.useAmbientOcclusion(), particle, context.getTransforms(), overrides, (ImmutableMap<String, BakedModel>)bakedParts, (ImmutableList<BakedModel>)itemPassesBuilder.build());
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> textures = new HashSet<Material>();
        if (context.hasMaterial("particle")) {
            textures.add(context.getMaterial("particle"));
        }
        for (BlockModel part : this.children.values()) {
            textures.addAll(part.m_5500_(modelGetter, missingTextureErrors));
        }
        return textures;
    }

    public Set<String> getConfigurableComponentNames() {
        return this.children.keySet();
    }

    public class Baked
    implements IDynamicBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final ItemOverrides overrides;
        private final ItemTransforms transforms;
        private final ImmutableMap<String, BakedModel> children;
        private final ImmutableList<BakedModel> itemPasses;

        public Baked(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, TextureAtlasSprite particle, ItemTransforms transforms, ItemOverrides overrides, ImmutableMap<String, BakedModel> children, ImmutableList<BakedModel> itemPasses) {
            this.children = children;
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.transforms = transforms;
            this.itemPasses = itemPasses;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.children.entrySet()) {
                if (renderType != null && (state == null || !((BakedModel)entry.getValue()).getRenderTypes(state, rand, data).contains(renderType))) continue;
                FramedDrawerModelData framedDrawerModelData = (FramedDrawerModelData)data.get(FramedDrawerModelData.FRAMED_PROPERTY);
                List quads = ((BakedModel)entry.getValue()).getQuads(state, side, rand, Data.resolve(data, (String)entry.getKey()), renderType);
                if (framedDrawerModelData != null && framedDrawerModelData.getDesign().containsKey(entry.getKey())) {
                    Item item = framedDrawerModelData.getDesign().get(entry.getKey());
                    quadLists.add(Baked.getQuadsUsingShape(item, quads, side, rand, renderType));
                    continue;
                }
                quadLists.add(quads);
            }
            return ConcatenatedListView.of(quadLists);
        }

        protected static List<BakedQuad> getQuadsUsingShape(@Nullable Item frameItem, List<BakedQuad> shape, @Nullable Direction side, RandomSource rand, @Nullable RenderType renderType) {
            if (frameItem instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)frameItem;
                BlockState state1 = blockItem.m_40614_().m_49966_();
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state1);
                Optional<List<Triple<TextureAtlasSprite, Integer, int[]>>> spriteOptional = Baked.getSpriteData(model, state1, side, rand, null, renderType);
                ArrayList<BakedQuad> returnQuads = new ArrayList<BakedQuad>();
                for (BakedQuad shapeQuad : shape) {
                    List<Triple<TextureAtlasSprite, Integer, int[]>> spriteData = spriteOptional.orElse(Baked.getSpriteFromModel(shapeQuad, model, state1, null));
                    returnQuads.addAll(Baked.framedQuad(shapeQuad, spriteData, state1.getLightEmission((BlockGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_)));
                }
                return returnQuads;
            }
            return List.of();
        }

        private static Optional<List<Triple<TextureAtlasSprite, Integer, int[]>>> getSpriteData(BakedModel model, BlockState state, @Nullable Direction side, RandomSource rand, @Nullable Direction rotation, @Nullable RenderType renderType) {
            List quads = model.getQuads(state, side, rand, ModelData.EMPTY, renderType);
            ArrayList<Float> positions = new ArrayList<Float>();
            ArrayList<ImmutableTriple> modelData = new ArrayList<ImmutableTriple>();
            if (!quads.isEmpty()) {
                for (BakedQuad bakedQuad : quads) {
                    float[] position = Baked.unpackVertices(bakedQuad.m_111303_(), 0, IQuadTransformer.POSITION, 3);
                    positions.add(Float.valueOf(Baked.getPositionFromDirection(position, side)));
                }
                List<Integer> index = Baked.getMinMaxPosition(positions, side);
                for (int i = 0; i < index.size(); ++i) {
                    int[] lights = new int[4];
                    for (int j = 0; j < 4; ++j) {
                        lights[j] = ((BakedQuad)quads.get(i)).m_111303_()[IQuadTransformer.UV2 + j * IQuadTransformer.STRIDE];
                    }
                    int tint = ((BakedQuad)quads.get(i)).m_111304_() ? Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, null, ((BakedQuad)quads.get(i)).m_111305_()) : -1;
                    ImmutableTriple triple = new ImmutableTriple((Object)((BakedQuad)quads.get(i)).m_173410_(), (Object)tint, (Object)lights);
                    modelData.add(triple);
                }
            }
            return quads.isEmpty() ? Optional.empty() : Optional.of(modelData);
        }

        private static float getPositionFromDirection(float[] position, Direction side) {
            Vec3i normal = new Vec3i(0, 0, 0);
            if (side != null) {
                normal = side.m_122436_();
            }
            Vector3f vector3f = new Vector3f(position[0] * (float)normal.m_123341_(), position[1] * (float)normal.m_123342_(), position[2] * (float)normal.m_123343_());
            return (float)Math.sqrt(vector3f.m_122276_(vector3f));
        }

        private static List<Integer> getMinMaxPosition(List<Float> positions, Direction side) {
            ArrayList<Integer> index = new ArrayList<Integer>();
            float minMax = side != null && side.m_122421_() == Direction.AxisDirection.POSITIVE ? Collections.max(positions).floatValue() : Collections.min(positions).floatValue();
            for (int i = 0; i < positions.size(); ++i) {
                if (!((double)Math.abs(positions.get(i).floatValue() - minMax) < 0.1)) continue;
                index.add(i);
            }
            return index;
        }

        protected static List<Triple<TextureAtlasSprite, Integer, int[]>> getSpriteFromModel(BakedQuad shape, BakedModel model, BlockState state, Direction rotation) {
            List quads = model.m_213637_(state, shape.m_111306_(), RandomSource.m_216327_());
            ArrayList<Float> positions = new ArrayList<Float>();
            ArrayList<Triple<TextureAtlasSprite, Integer, int[]>> modelData = new ArrayList<Triple<TextureAtlasSprite, Integer, int[]>>();
            if (!quads.isEmpty()) {
                for (BakedQuad bakedQuad : quads) {
                    float[] position = Baked.unpackVertices(bakedQuad.m_111303_(), 0, IQuadTransformer.POSITION, 3);
                    positions.add(Float.valueOf(Baked.getPositionFromDirection(position, shape.m_111306_())));
                }
                List<Integer> index = Baked.getMinMaxPosition(positions, shape.m_111306_());
                for (int i = 0; i < index.size(); ++i) {
                    int[] lights = new int[4];
                    for (int j = 0; j < 4; ++j) {
                        lights[j] = ((BakedQuad)quads.get(i)).m_111303_()[IQuadTransformer.UV2 + j * IQuadTransformer.STRIDE];
                    }
                    int tint = ((BakedQuad)quads.get(i)).m_111304_() ? Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, null, ((BakedQuad)quads.get(i)).m_111305_()) : -1;
                    ImmutableTriple triple = new ImmutableTriple((Object)((BakedQuad)quads.get(i)).m_173410_(), (Object)tint, (Object)lights);
                    modelData.add((Triple<TextureAtlasSprite, Integer, int[]>)triple);
                }
            }
            return quads.isEmpty() ? List.of(Triple.of((Object)((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_())), (Object)-1, (Object)new int[]{0, 0, 0, 0})) : modelData;
        }

        protected static List<BakedQuad> framedQuad(BakedQuad toCopy, List<Triple<TextureAtlasSprite, Integer, int[]>> modelData, int lightEmission) {
            lightEmission = LightTexture.m_109885_((int)lightEmission, (int)lightEmission);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (int j = 0; j < modelData.size(); ++j) {
                BakedQuad copied = new BakedQuad(Arrays.copyOf(toCopy.m_111303_(), 32), -1, toCopy.m_111306_(), (TextureAtlasSprite)modelData.get(j).getLeft(), toCopy.m_111307_());
                for (int i = 0; i < 4; ++i) {
                    float[] uv0 = Baked.unpackVertices(copied.m_111303_(), i, IQuadTransformer.UV0, 2);
                    uv0[0] = (uv0[0] - toCopy.m_173410_().m_118409_()) * (float)((TextureAtlasSprite)modelData.get(j).getLeft()).m_118405_() / (float)toCopy.m_173410_().m_118405_() + ((TextureAtlasSprite)modelData.get(j).getLeft()).m_118409_();
                    uv0[1] = (uv0[1] - toCopy.m_173410_().m_118411_()) * (float)((TextureAtlasSprite)modelData.get(j).getLeft()).m_118408_() / (float)toCopy.m_173410_().m_118408_() + ((TextureAtlasSprite)modelData.get(j).getLeft()).m_118411_();
                    int[] packedTextureData = Baked.packUV(uv0[0], uv0[1]);
                    copied.m_111303_()[IQuadTransformer.UV0 + i * IQuadTransformer.STRIDE] = packedTextureData[0];
                    copied.m_111303_()[IQuadTransformer.UV0 + 1 + i * IQuadTransformer.STRIDE] = packedTextureData[1];
                    if ((Integer)modelData.get(j).getMiddle() != -1) {
                        int packedColor;
                        int[] colors = Baked.getColorARGB(copied.m_111303_(), i);
                        int[] color1 = Baked.getColorARGB((Integer)modelData.get(j).getMiddle());
                        colors[0] = colors[0] * color1[0] / 255;
                        colors[1] = colors[1] * color1[1] / 255;
                        colors[2] = colors[2] * color1[2] / 255;
                        colors[3] = colors[3] * color1[3] / 255;
                        copied.m_111303_()[IQuadTransformer.COLOR + i * IQuadTransformer.STRIDE] = packedColor = Baked.packColor(colors[3], colors[2], colors[1], colors[0]);
                    }
                    copied.m_111303_()[IQuadTransformer.UV2 + i * IQuadTransformer.STRIDE] = Math.max(((int[])modelData.get(j).getRight())[i], lightEmission);
                }
                quads.add(copied);
            }
            return quads;
        }

        private static float[] unpackVertices(int[] vertices, int vertexIndex, int position, int count) {
            float[] floats = new float[count];
            int startIndex = vertexIndex * IQuadTransformer.STRIDE + position;
            for (int i = 0; i < count; ++i) {
                floats[i] = Float.intBitsToFloat(vertices[startIndex + i]);
            }
            return floats;
        }

        private static int[] getColorARGB(int[] vertices, int vertexIndex) {
            int color = vertices[IQuadTransformer.STRIDE * vertexIndex + IQuadTransformer.COLOR];
            return Baked.getColorARGB(color);
        }

        private static int[] getColorARGB(int color) {
            int[] argb = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
            return argb;
        }

        private static int[] getUV2(int[] vertices, int vertexIndex) {
            int[] light = new int[2];
            int uv2 = vertices[IQuadTransformer.STRIDE * vertexIndex + IQuadTransformer.UV2];
            light[0] = (uv2 & 0xFFFF) >> 4;
            light[1] = uv2 >> 20 & 0xFFFF;
            return light;
        }

        public static int[] packUV(float u, float v) {
            int[] quadData = new int[]{Float.floatToRawIntBits(u), Float.floatToRawIntBits(v)};
            return quadData;
        }

        public static int packColor(int r, int g, int b, int a) {
            return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }

        public static int packUV2(int u, int v) {
            return u << 4 | v << 20;
        }

        public boolean m_7541_() {
            return this.isAmbientOcclusion;
        }

        public boolean m_7539_() {
            return this.isGui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
            Item item;
            FramedDrawerModelData framedDrawerModelData = (FramedDrawerModelData)data.get(FramedDrawerModelData.FRAMED_PROPERTY);
            if (framedDrawerModelData != null && framedDrawerModelData.getDesign().containsKey("particle") && (item = framedDrawerModelData.getDesign().get("particle")) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                return Minecraft.m_91087_().m_91289_().m_110910_(blockItem.m_40614_().m_49966_()).getParticleIcon(data);
            }
            return this.particle;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public ItemTransforms m_7442_() {
            return this.transforms;
        }

        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            ArrayList<ChunkRenderTypeSet> sets = new ArrayList<ChunkRenderTypeSet>();
            for (Map.Entry entry : this.children.entrySet()) {
                sets.add(((BakedModel)entry.getValue()).getRenderTypes(state, rand, Data.resolve(data, (String)entry.getKey())));
            }
            return ChunkRenderTypeSet.union(sets);
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
            return List.of(new ItemModel(this, itemStack));
        }

        @Nullable
        public BakedModel getPart(String name) {
            return (BakedModel)this.children.get((Object)name);
        }
    }

    private class ItemModel
    implements IDynamicBakedModel {
        private final Baked baked;
        private final ItemStack itemStack;

        public ItemModel(Baked baked, ItemStack itemStack) {
            this.baked = baked;
            this.itemStack = itemStack;
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.baked.children.entrySet()) {
                if (renderType != null && (state == null || !((BakedModel)entry.getValue()).getRenderTypes(state, rand, extraData).contains(renderType))) continue;
                List quads = ((BakedModel)entry.getValue()).getQuads(state, side, rand, Data.resolve(extraData, (String)entry.getKey()), renderType);
                FramedDrawerModelData framedDrawerModelData = FramedDrawerBlock.getDrawerModelData(this.itemStack);
                if (framedDrawerModelData != null && framedDrawerModelData.getDesign().containsKey(entry.getKey())) {
                    Item item = framedDrawerModelData.getDesign().get(entry.getKey());
                    quadLists.add(Baked.getQuadsUsingShape(item, quads, side, rand, renderType));
                    continue;
                }
                quadLists.add(quads);
            }
            return ConcatenatedListView.of(quadLists);
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.baked.m_6160_();
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }

        public ItemTransforms m_7442_() {
            return this.baked.m_7442_();
        }
    }

    public static final class Loader
    implements IGeometryLoader<FramedModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public FramedModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            ArrayList<String> itemPasses = new ArrayList<String>();
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            this.readChildren(jsonObject, "children", deserializationContext, (ImmutableMap.Builder<String, BlockModel>)childrenBuilder, itemPasses, false);
            boolean logWarning = this.readChildren(jsonObject, "parts", deserializationContext, (ImmutableMap.Builder<String, BlockModel>)childrenBuilder, itemPasses, true);
            ImmutableMap children = childrenBuilder.build();
            if (children.isEmpty()) {
                throw new JsonParseException("Composite model requires a \"children\" element with at least one element.");
            }
            if (jsonObject.has("item_render_order")) {
                itemPasses.clear();
                for (JsonElement element : jsonObject.getAsJsonArray("item_render_order")) {
                    String name = element.getAsString();
                    if (!children.containsKey((Object)name)) {
                        throw new JsonParseException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
                    }
                    itemPasses.add(name);
                }
            }
            return new FramedModel((ImmutableMap<String, BlockModel>)children, (ImmutableList<String>)ImmutableList.copyOf(itemPasses), logWarning);
        }

        private boolean readChildren(JsonObject jsonObject, String name, JsonDeserializationContext deserializationContext, ImmutableMap.Builder<String, BlockModel> children, List<String> itemPasses, boolean logWarning) {
            if (!jsonObject.has(name)) {
                return false;
            }
            JsonObject childrenJsonObject = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : childrenJsonObject.entrySet()) {
                children.put((Object)((String)entry.getKey()), (Object)((BlockModel)deserializationContext.deserialize((JsonElement)entry.getValue(), BlockModel.class)));
                itemPasses.add((String)entry.getKey());
            }
            return logWarning;
        }
    }

    public static class Data {
        public static final ModelProperty<Data> PROPERTY = new ModelProperty();
        private final Map<String, ModelData> partData;

        private Data(Map<String, ModelData> partData) {
            this.partData = partData;
        }

        @Nullable
        public ModelData get(String name) {
            return this.partData.get(name);
        }

        public static ModelData resolve(ModelData modelData, String name) {
            Data compositeData = (Data)modelData.get(PROPERTY);
            if (compositeData == null) {
                return modelData;
            }
            ModelData partData = compositeData.get(name);
            return partData != null ? partData : modelData;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private final Map<String, ModelData> partData = new IdentityHashMap<String, ModelData>();

            public Builder with(String name, ModelData data) {
                this.partData.put(name, data);
                return this;
            }

            public Data build() {
                return new Data(this.partData);
            }
        }
    }
}

