/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.misc;

import at.petrak.hexcasting.api.addldata.ADColorizer;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public record FrozenColorizer(ItemStack item, UUID owner) {
    private static final int[] MINIMUM_LUMINANCE_COLOR_WHEEL = new int[]{-14680064, -14671872, -16769024, -16768992, -16777184, -14680032};
    public static final String TAG_STACK = "stack";
    public static final String TAG_OWNER = "owner";
    public static final Supplier<FrozenColorizer> DEFAULT = () -> new FrozenColorizer(new ItemStack((ItemLike)HexItems.DYE_COLORIZERS.get(DyeColor.WHITE)), Util.f_137441_);

    public CompoundTag serializeToNBT() {
        CompoundTag out = new CompoundTag();
        out.m_128365_(TAG_STACK, (Tag)this.item.m_41739_(new CompoundTag()));
        out.m_128362_(TAG_OWNER, this.owner);
        return out;
    }

    public static FrozenColorizer fromNBT(CompoundTag tag) {
        if (tag.m_128456_()) {
            return DEFAULT.get();
        }
        try {
            CompoundTag stackTag = tag.m_128469_(TAG_STACK);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)stackTag);
            UUID uuid = tag.m_128342_(TAG_OWNER);
            return new FrozenColorizer(stack, uuid);
        }
        catch (NullPointerException exn) {
            return DEFAULT.get();
        }
    }

    public int getColor(float time, Vec3 position) {
        int b;
        int g;
        int raw = IXplatAbstractions.INSTANCE.getRawColor(this, time, position);
        int r = FastColor.ARGB32.m_13665_((int)raw);
        double luminance = (0.2126 * (double)r + 0.7152 * (double)(g = FastColor.ARGB32.m_13667_((int)raw)) + 0.0722 * (double)(b = FastColor.ARGB32.m_13669_((int)raw))) / 255.0;
        if (luminance < 0.05) {
            int rawMod = ADColorizer.morphBetweenColors(MINIMUM_LUMINANCE_COLOR_WHEEL, new Vec3(0.1, 0.1, 0.1), time / 20.0f / 20.0f, position);
            r += FastColor.ARGB32.m_13665_((int)rawMod);
            g += FastColor.ARGB32.m_13667_((int)rawMod);
            b += FastColor.ARGB32.m_13669_((int)rawMod);
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

