/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell;

import at.petrak.hexcasting.api.spell.iota.Iota;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0019\u001a\u001bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\"\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0015J\u0006\u0010\u0016\u001a\u00020\u0010J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0012\u0010\u0004\u001a\u00020\u0002X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0001\u0002\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lat/petrak/hexcasting/api/spell/SpellList;", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "()V", "car", "getCar", "()Lat/petrak/hexcasting/api/spell/iota/Iota;", "cdr", "getCdr", "()Lat/petrak/hexcasting/api/spell/SpellList;", "nonEmpty", "", "getNonEmpty", "()Z", "getAt", "startIdx", "", "iterator", "Lat/petrak/hexcasting/api/spell/SpellList$SpellListIterator;", "modifyAt", "modify", "Lkotlin/Function1;", "size", "toString", "", "LList", "LPair", "SpellListIterator", "Lat/petrak/hexcasting/api/spell/SpellList$LList;", "Lat/petrak/hexcasting/api/spell/SpellList$LPair;", "hexcasting-forge-1.19.2"})
public abstract class SpellList
implements Iterable<Iota>,
KMappedMarker {
    private SpellList() {
    }

    public abstract boolean getNonEmpty();

    @NotNull
    public abstract Iota getCar();

    @NotNull
    public abstract SpellList getCdr();

    @NotNull
    public final SpellList modifyAt(int startIdx, @NotNull Function1<? super SpellList, ? extends SpellList> modify) {
        int idx;
        Intrinsics.checkNotNullParameter(modify, (String)"modify");
        List stack = new ArrayList();
        SpellListIterator ptr = this.iterator();
        if (idx < 0) {
            return this;
        }
        for (idx = startIdx; idx > 0; --idx) {
            if (!ptr.hasNext()) {
                return this;
            }
            stack.add(ptr.next());
        }
        SpellList value = (SpellList)modify.invoke((Object)ptr.getList());
        for (Iota datum : CollectionsKt.asReversedMutable((List)stack)) {
            value = new LPair(datum, value);
        }
        return value;
    }

    @NotNull
    public final Iota getAt(int startIdx) {
        SpellList ptr = this;
        int idx = startIdx;
        if (idx < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        while (idx > 0) {
            SpellList spellList = ptr;
            if (spellList instanceof LPair) {
                ptr = ptr.getCdr();
            } else if (spellList instanceof LList) {
                return ((LList)ptr).getList().get(((LList)ptr).getIdx() + idx);
            }
            --idx;
        }
        return ptr.getCar();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.toList((Iterable)this).toString();
    }

    @NotNull
    public SpellListIterator iterator() {
        return new SpellListIterator(this);
    }

    public final int size() {
        int size = 0;
        SpellList ptr = this;
        while (ptr.getNonEmpty()) {
            ptr = ptr.getCdr();
            ++size;
        }
        return size;
    }

    public /* synthetic */ SpellList(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lat/petrak/hexcasting/api/spell/SpellList$LPair;", "Lat/petrak/hexcasting/api/spell/SpellList;", "car", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "cdr", "(Lat/petrak/hexcasting/api/spell/iota/Iota;Lat/petrak/hexcasting/api/spell/SpellList;)V", "getCar", "()Lat/petrak/hexcasting/api/spell/iota/Iota;", "getCdr", "()Lat/petrak/hexcasting/api/spell/SpellList;", "nonEmpty", "", "getNonEmpty", "()Z", "hexcasting-forge-1.19.2"})
    public static final class LPair
    extends SpellList {
        @NotNull
        private final Iota car;
        @NotNull
        private final SpellList cdr;
        private final boolean nonEmpty;

        public LPair(@NotNull Iota car, @NotNull SpellList cdr) {
            Intrinsics.checkNotNullParameter((Object)car, (String)"car");
            Intrinsics.checkNotNullParameter((Object)cdr, (String)"cdr");
            super(null);
            this.car = car;
            this.cdr = cdr;
            this.nonEmpty = true;
        }

        @Override
        @NotNull
        public Iota getCar() {
            return this.car;
        }

        @Override
        @NotNull
        public SpellList getCdr() {
            return this.cdr;
        }

        @Override
        public boolean getNonEmpty() {
            return this.nonEmpty;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u001b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lat/petrak/hexcasting/api/spell/SpellList$LList;", "Lat/petrak/hexcasting/api/spell/SpellList;", "list", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "(Ljava/util/List;)V", "idx", "", "(ILjava/util/List;)V", "car", "getCar", "()Lat/petrak/hexcasting/api/spell/iota/Iota;", "cdr", "getCdr", "()Lat/petrak/hexcasting/api/spell/SpellList;", "getIdx", "()I", "getList", "()Ljava/util/List;", "nonEmpty", "", "getNonEmpty", "()Z", "hexcasting-forge-1.19.2"})
    public static final class LList
    extends SpellList {
        private final int idx;
        @NotNull
        private final List<Iota> list;

        public LList(int idx, @NotNull List<? extends Iota> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            super(null);
            this.idx = idx;
            this.list = list;
        }

        public final int getIdx() {
            return this.idx;
        }

        @NotNull
        public final List<Iota> getList() {
            return this.list;
        }

        @Override
        public boolean getNonEmpty() {
            return this.idx < this.list.size();
        }

        @Override
        @NotNull
        public Iota getCar() {
            return this.list.get(this.idx);
        }

        @Override
        @NotNull
        public SpellList getCdr() {
            return new LList(this.idx + 1, this.list);
        }

        public LList(@NotNull List<? extends Iota> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this(0, list);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\t\u0010\u000b\u001a\u00020\u0002H\u0096\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\f"}, d2={"Lat/petrak/hexcasting/api/spell/SpellList$SpellListIterator;", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "list", "Lat/petrak/hexcasting/api/spell/SpellList;", "(Lat/petrak/hexcasting/api/spell/SpellList;)V", "getList", "()Lat/petrak/hexcasting/api/spell/SpellList;", "setList", "hasNext", "", "next", "hexcasting-forge-1.19.2"})
    public static final class SpellListIterator
    implements Iterator<Iota>,
    KMappedMarker {
        @NotNull
        private SpellList list;

        public SpellListIterator(@NotNull SpellList list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            this.list = list;
        }

        @NotNull
        public final SpellList getList() {
            return this.list;
        }

        public final void setList(@NotNull SpellList spellList) {
            Intrinsics.checkNotNullParameter((Object)spellList, (String)"<set-?>");
            this.list = spellList;
        }

        @Override
        public boolean hasNext() {
            return this.list.getNonEmpty();
        }

        @Override
        @NotNull
        public Iota next() {
            Iota car = this.list.getCar();
            this.list = this.list.getCdr();
            return car;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

