/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.entity;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.lib.HexSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockEntityLookingImpetus
extends BlockEntityAbstractImpetus {
    public static final int MAX_LOOK_AMOUNT = 30;
    public static final String TAG_LOOK_AMOUNT = "look_amount";
    private int lookAmount = 0;

    public BlockEntityLookingImpetus(BlockPos pWorldPosition, BlockState pBlockState) {
        super(HexBlockEntities.IMPETUS_LOOK_TILE, pWorldPosition, pBlockState);
    }

    @Override
    public boolean activatorAlwaysInRange() {
        return false;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState bs, BlockEntityLookingImpetus self) {
        int newLook;
        if (((Boolean)bs.m_61143_((Property)BlockCircleComponent.ENERGIZED)).booleanValue()) {
            return;
        }
        int prevLookAmt = self.lookAmount;
        int range = 20;
        List players = level.m_45976_(ServerPlayer.class, new AABB(pos.m_7918_(-range, -range, -range), pos.m_7918_(range, range, range)));
        ServerPlayer looker = null;
        for (ServerPlayer player : players) {
            ItemStack hat = player.m_6844_(EquipmentSlot.HEAD);
            if (!hat.m_41619_() && hat.m_150930_(Blocks.f_50143_.m_5456_())) continue;
            Vec3 lookEnd = player.m_20154_().m_82490_((double)((float)range / 1.5f));
            BlockHitResult hit = level.m_45547_(new ClipContext(player.m_146892_(), player.m_146892_().m_82549_(lookEnd), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
            if (hit.m_6662_() != HitResult.Type.BLOCK || !hit.m_82425_().equals((Object)pos)) continue;
            looker = player;
            break;
        }
        if ((newLook = Mth.m_14045_((int)(prevLookAmt + (looker == null ? -1 : 1)), (int)0, (int)30)) != prevLookAmt) {
            if (newLook == 30) {
                self.lookAmount = 0;
                self.activateSpellCircle(looker);
            } else {
                if (newLook % 5 == 1) {
                    float t = (float)newLook / 30.0f;
                    float pitch = Mth.m_14179_((float)t, (float)0.5f, (float)1.2f);
                    float volume = Mth.m_14179_((float)t, (float)0.2f, (float)1.2f);
                    level.m_5594_(null, pos, HexSounds.IMPETUS_LOOK_TICK, SoundSource.BLOCKS, volume, pitch);
                }
                self.lookAmount = newLook;
                self.m_6596_();
            }
        }
    }

    @Override
    protected void saveModData(CompoundTag tag) {
        super.saveModData(tag);
        tag.m_128405_(TAG_LOOK_AMOUNT, this.lookAmount);
    }

    @Override
    protected void loadModData(CompoundTag tag) {
        super.loadModData(tag);
        this.lookAmount = tag.m_128451_(TAG_LOOK_AMOUNT);
    }
}

