/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib.hex;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.spell.iota.BooleanIota;
import at.petrak.hexcasting.api.spell.iota.DoubleIota;
import at.petrak.hexcasting.api.spell.iota.EntityIota;
import at.petrak.hexcasting.api.spell.iota.GarbageIota;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.IotaType;
import at.petrak.hexcasting.api.spell.iota.ListIota;
import at.petrak.hexcasting.api.spell.iota.NullIota;
import at.petrak.hexcasting.api.spell.iota.PatternIota;
import at.petrak.hexcasting.api.spell.iota.Vec3Iota;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class HexIotaTypes {
    public static final Registry<IotaType<?>> REGISTRY = IXplatAbstractions.INSTANCE.getIotaTypeRegistry();
    public static final String KEY_TYPE = "hexcasting:type";
    public static final String KEY_DATA = "hexcasting:data";
    public static final int MAX_SERIALIZATION_DEPTH = 256;
    public static final int MAX_SERIALIZATION_TOTAL = 1024;
    private static final Map<ResourceLocation, IotaType<?>> TYPES = new LinkedHashMap();
    public static final IotaType<NullIota> NULL = HexIotaTypes.type("null", NullIota.TYPE);
    public static final IotaType<DoubleIota> DOUBLE = HexIotaTypes.type("double", DoubleIota.TYPE);
    public static final IotaType<BooleanIota> BOOLEAN = HexIotaTypes.type("boolean", BooleanIota.TYPE);
    public static final IotaType<EntityIota> ENTITY = HexIotaTypes.type("entity", EntityIota.TYPE);
    public static final IotaType<ListIota> LIST = HexIotaTypes.type("list", ListIota.TYPE);
    public static final IotaType<PatternIota> PATTERN = HexIotaTypes.type("pattern", PatternIota.TYPE);
    public static final IotaType<GarbageIota> GARBAGE = HexIotaTypes.type("garbage", GarbageIota.TYPE);
    public static final IotaType<Vec3Iota> VEC3 = HexIotaTypes.type("vec3", Vec3Iota.TYPE);

    public static CompoundTag serialize(Iota iota) {
        ListIota listIota;
        IotaType<?> type = iota.getType();
        ResourceLocation typeId = REGISTRY.m_7981_(type);
        if (typeId == null) {
            throw new IllegalStateException("Tried to serialize an unregistered iota type. Iota: " + iota + " ; Type" + type.getClass().getTypeName());
        }
        if (iota instanceof ListIota && HexIotaTypes.isTooLargeToSerialize((listIota = (ListIota)iota).getList())) {
            return HexIotaTypes.serialize(new GarbageIota());
        }
        Tag dataTag = iota.serialize();
        CompoundTag out = new CompoundTag();
        out.m_128359_(KEY_TYPE, typeId.toString());
        out.m_128365_(KEY_DATA, dataTag);
        return out;
    }

    public static boolean isTooLargeToSerialize(Iterable<Iota> examinee) {
        ArrayDeque<Pair> listsToExamine = new ArrayDeque<Pair>(Collections.singleton(new Pair(examinee, (Object)0)));
        int totalEltsFound = 1;
        while (!listsToExamine.isEmpty()) {
            Pair iotaPair = listsToExamine.removeFirst();
            Iterable sublist = (Iterable)iotaPair.getFirst();
            int depth = (Integer)iotaPair.getSecond();
            for (Iota iota : sublist) {
                if (++totalEltsFound >= 1024) {
                    return true;
                }
                if (!(iota instanceof ListIota)) continue;
                ListIota subsublist = (ListIota)iota;
                if (depth + 1 >= 256) {
                    return true;
                }
                listsToExamine.addLast(new Pair((Object)subsublist.getList(), (Object)(depth + 1)));
            }
        }
        return false;
    }

    @Nullable
    public static IotaType<?> getTypeFromTag(CompoundTag tag) {
        if (!tag.m_128425_(KEY_TYPE, 8)) {
            return null;
        }
        String typeKey = tag.m_128461_(KEY_TYPE);
        if (!ResourceLocation.m_135830_((String)typeKey)) {
            return null;
        }
        ResourceLocation typeLoc = new ResourceLocation(typeKey);
        return (IotaType)REGISTRY.m_7745_(typeLoc);
    }

    public static Iota deserialize(CompoundTag tag, ServerLevel world) {
        Iota deserialized;
        IotaType<?> type = HexIotaTypes.getTypeFromTag(tag);
        if (type == null) {
            return new GarbageIota();
        }
        Tag data = tag.m_128423_(KEY_DATA);
        if (data == null) {
            return new GarbageIota();
        }
        try {
            deserialized = Objects.requireNonNullElse(type.deserialize(data, world), new NullIota());
        }
        catch (IllegalArgumentException exn) {
            HexAPI.LOGGER.warn("Caught an exception deserializing an iota", (Throwable)exn);
            deserialized = new GarbageIota();
        }
        return deserialized;
    }

    private static Component brokenIota() {
        return Component.m_237115_((String)"hexcasting.spelldata.unknown").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    }

    public static Component getDisplay(CompoundTag tag) {
        IotaType<?> type = HexIotaTypes.getTypeFromTag(tag);
        if (type == null) {
            return HexIotaTypes.brokenIota();
        }
        Tag data = tag.m_128423_(KEY_DATA);
        if (data == null) {
            return HexIotaTypes.brokenIota();
        }
        return type.display(data);
    }

    public static FormattedCharSequence getDisplayWithMaxWidth(CompoundTag tag, int maxWidth, Font font) {
        IotaType<?> type = HexIotaTypes.getTypeFromTag(tag);
        if (type == null) {
            return HexIotaTypes.brokenIota().m_7532_();
        }
        Tag data = tag.m_128423_(KEY_DATA);
        if (data == null) {
            return HexIotaTypes.brokenIota().m_7532_();
        }
        Component display = type.display(data);
        List splitted = font.m_92923_((FormattedText)display, maxWidth - font.m_92895_("..."));
        if (splitted.isEmpty()) {
            return FormattedCharSequence.f_13691_;
        }
        if (splitted.size() == 1) {
            return (FormattedCharSequence)splitted.get(0);
        }
        FormattedCharSequence first = (FormattedCharSequence)splitted.get(0);
        return FormattedCharSequence.m_13733_((FormattedCharSequence)first, (FormattedCharSequence)Component.m_237113_((String)"...").m_130940_(ChatFormatting.GRAY).m_7532_());
    }

    public static int getColor(CompoundTag tag) {
        IotaType<?> type = HexIotaTypes.getTypeFromTag(tag);
        if (type == null) {
            return -524040;
        }
        return type.color();
    }

    @ApiStatus.Internal
    public static void registerTypes() {
        BiConsumer<IotaType, ResourceLocation> r = (type, id) -> Registry.m_122965_(REGISTRY, (ResourceLocation)id, (Object)type);
        for (Map.Entry<ResourceLocation, IotaType<?>> e : TYPES.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static <U extends Iota, T extends IotaType<U>> T type(String name, T type) {
        IotaType<?> old = TYPES.put(HexAPI.modLoc(name), type);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return type;
    }
}

