/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.recipes.DryingRackRecipe;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;

public class DryingRackTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
Clearable,
MenuProvider {
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    public boolean[] crafted = new boolean[]{false, false, false};
    public boolean[] crafting = new boolean[]{false, false, false};
    public int[] dryingTimeMax = new int[]{200, 200, 200};
    public int[] dryingTime = new int[]{200, 200, 200};
    public int[] placedTime = new int[]{0, 0, 0};
    public ItemStack[] output = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_};
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public DryingRackTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    public void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public int m_6893_() {
        return 3;
    }

    public void m_6596_() {
        super.m_6596_();
        this.sync();
    }

    public void sync() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return switch (facing) {
                case Direction.UP -> this.handlers[0].cast();
                case Direction.DOWN -> this.handlers[1].cast();
                default -> this.handlers[2].cast();
            };
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }

    public Item getItemInSlot(int slot) {
        return ((ItemStack)this.items.get(slot)).m_41720_();
    }

    public int getNumberOfItems() {
        int num = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.items.get(i) == ItemStack.f_41583_) continue;
            ++num;
        }
        return num;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    public DryingRackTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.DRYING_RACK_TILE.get(), blockPos, blockState);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.items.size()) {
            ItemStack itemStack = stack.m_41777_();
            this.items.set(index, (Object)itemStack);
            if (index == 0) {
                this.dryingTime[0] = this.dryingTimeMax[0];
            }
            if (index == 1) {
                this.dryingTime[1] = this.dryingTimeMax[1];
            }
            if (index == 2) {
                this.dryingTime[2] = this.dryingTimeMax[2];
            }
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
        }
        this.sync();
    }

    public ItemStack m_7407_(int index, int p_59614_) {
        this.m_59640_(null);
        ItemStack itemstack = ContainerHelper.m_18969_(this.m_7086_(), (int)index, (int)p_59614_);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
            if (index == 0) {
                this.crafted[0] = false;
                this.sync();
            }
            if (index == 0) {
                this.crafted[1] = false;
                this.sync();
            }
            if (index == 0) {
                this.crafted[2] = false;
                this.sync();
            }
        }
        return itemstack;
    }

    public void craft() {
        ArrayList<SimpleContainer> inv = new ArrayList<SimpleContainer>();
        inv.add(new SimpleContainer(1));
        inv.add(new SimpleContainer(1));
        inv.add(new SimpleContainer(1));
        for (int i = 0; i < 3; ++i) {
            ((SimpleContainer)inv.get(i)).m_6836_(0, (ItemStack)this.items.get(i));
            Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)DryingRackRecipe.Type.INSTANCE, (Container)((SimpleContainer)inv.get(i)), this.f_58857_);
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_);
            if (!(blockEntity instanceof DryingRackTile)) continue;
            int j = i;
            recipe.ifPresent(iRecipe -> {
                ItemStack recipeOutput = iRecipe.m_8043_();
                ItemStack input = ((Ingredient)iRecipe.m_7527_().get(0)).m_43908_()[0];
                if (input.m_41720_() == ((ItemStack)this.items.get(j)).m_41720_()) {
                    if (!this.crafting[j]) {
                        this.crafting[j] = true;
                        this.output[j] = recipeOutput.m_41777_();
                        this.dryingTimeMax[j] = iRecipe.getDryingTime();
                        this.dryingTime[j] = this.dryingTimeMax[j];
                        this.sync();
                    }
                } else if (this.crafting[j]) {
                    this.crafting[j] = false;
                    this.sync();
                }
            });
        }
    }

    private void craftTheItem(ItemStack output, int slot) {
        output.m_41764_(((ItemStack)this.items.get(slot)).m_41613_());
        this.m_6836_(slot, output);
    }

    public void m_142466_(CompoundTag nbt) {
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        }
        if (nbt.m_128425_("dryingTime[0]", 3)) {
            this.dryingTime[0] = nbt.m_128451_("dryingTime[0]");
        }
        if (nbt.m_128425_("dryingTime[1]", 3)) {
            this.dryingTime[1] = nbt.m_128451_("dryingTime[1]");
        }
        if (nbt.m_128425_("dryingTime[2]", 3)) {
            this.dryingTime[2] = nbt.m_128451_("dryingTime[2]");
        }
        if (nbt.m_128425_("crafting[0]", 3)) {
            boolean bl = this.crafting[0] = nbt.m_128451_("crafting[0]") == 1;
        }
        if (nbt.m_128425_("crafting[1]", 3)) {
            boolean bl = this.crafting[1] = nbt.m_128451_("crafting[1]") == 1;
        }
        if (nbt.m_128425_("crafting[2]", 3)) {
            boolean bl = this.crafting[2] = nbt.m_128451_("crafting[2]") == 1;
        }
        if (nbt.m_128425_("crafted[0]", 3)) {
            boolean bl = this.crafted[0] = nbt.m_128451_("crafted[0]") == 1;
        }
        if (nbt.m_128425_("crafted[1]", 3)) {
            boolean bl = this.crafted[1] = nbt.m_128451_("crafted[1]") == 1;
        }
        if (nbt.m_128425_("crafted[2]", 3)) {
            boolean bl = this.crafted[2] = nbt.m_128451_("crafted[2]") == 1;
        }
        if (nbt.m_128425_("placedTime[0]", 3)) {
            this.placedTime[0] = nbt.m_128451_("placedTime[0]");
        }
        if (nbt.m_128425_("placedTime[1]", 3)) {
            this.placedTime[1] = nbt.m_128451_("placedTime[1]");
        }
        if (nbt.m_128425_("placedTime[2]", 3)) {
            this.placedTime[2] = nbt.m_128451_("placedTime[2]");
        }
        if (nbt.m_128441_("output[0]")) {
            this.output[0] = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("output[0]"));
        }
        if (nbt.m_128441_("output[1]")) {
            this.output[1] = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("output[1]"));
        }
        if (nbt.m_128441_("output[2]")) {
            this.output[2] = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("output[2]"));
        }
        super.m_142466_(nbt);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.hexerei.dipper");
    }

    protected AbstractContainerMenu m_6555_(int p_58627_, Inventory p_58628_) {
        return null;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128405_("dryingTime[0]", this.dryingTime[0]);
        compound.m_128405_("dryingTime[1]", this.dryingTime[1]);
        compound.m_128405_("dryingTime[2]", this.dryingTime[2]);
        compound.m_128405_("crafted[0]", this.crafted[0] ? 1 : 0);
        compound.m_128405_("crafted[1]", this.crafted[1] ? 1 : 0);
        compound.m_128405_("crafted[2]", this.crafted[2] ? 1 : 0);
        compound.m_128405_("crafting[0]", this.crafting[0] ? 1 : 0);
        compound.m_128405_("crafting[1]", this.crafting[1] ? 1 : 0);
        compound.m_128405_("crafting[2]", this.crafting[2] ? 1 : 0);
        compound.m_128405_("placedTime[0]", this.placedTime[0]);
        compound.m_128405_("placedTime[1]", this.placedTime[1]);
        compound.m_128405_("placedTime[2]", this.placedTime[2]);
        compound.m_128365_("output[0]", (Tag)this.output[0].m_41739_(new CompoundTag()));
        compound.m_128365_("output[1]", (Tag)this.output[1].m_41739_(new CompoundTag()));
        compound.m_128365_("output[2]", (Tag)this.output[2].m_41739_(new CompoundTag()));
    }

    public CompoundTag save(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128405_("dryingTime[0]", this.dryingTime[0]);
        compound.m_128405_("dryingTime[1]", this.dryingTime[1]);
        compound.m_128405_("dryingTime[2]", this.dryingTime[2]);
        compound.m_128405_("crafted[0]", this.crafted[0] ? 1 : 0);
        compound.m_128405_("crafted[1]", this.crafted[1] ? 1 : 0);
        compound.m_128405_("crafted[2]", this.crafted[2] ? 1 : 0);
        compound.m_128405_("crafting[0]", this.crafting[0] ? 1 : 0);
        compound.m_128405_("crafting[1]", this.crafting[1] ? 1 : 0);
        compound.m_128405_("crafting[2]", this.crafting[2] ? 1 : 0);
        compound.m_128405_("placedTime[0]", this.placedTime[0]);
        compound.m_128405_("placedTime[1]", this.placedTime[1]);
        compound.m_128405_("placedTime[2]", this.placedTime[2]);
        compound.m_128365_("output[0]", (Tag)this.output[0].m_41739_(new CompoundTag()));
        compound.m_128365_("output[1]", (Tag)this.output[1].m_41739_(new CompoundTag()));
        compound.m_128365_("output[2]", (Tag)this.output[2].m_41739_(new CompoundTag()));
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20182_().m_7096_() - (double)pos.m_123341_() - 0.5;
        double deltaY = entity.m_20182_().m_7098_() - (double)pos.m_123342_() - 0.5;
        double deltaZ = entity.m_20182_().m_7094_() - (double)pos.m_123343_() - 0.5;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static double getDistance(float x1, float y1, float x2, float y2) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
    }

    public float getAngle(Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.m_7094_() - (double)this.m_58899_().m_123343_() - 0.5, pos.m_7096_() - (double)this.m_58899_().m_123341_() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float getSpeed(double pos, double posTo) {
        return (float)((double)0.01f + (double)0.1f * (Math.abs(pos - posTo) / 3.0));
    }

    public Vec3 rotateAroundVec(Vec3 vector3dCenter, float rotation, Vec3 vector3d) {
        Vec3 newVec = vector3d.m_82546_(vector3dCenter);
        newVec = newVec.m_82524_(rotation / 180.0f * (float)Math.PI);
        newVec = newVec.m_82549_(vector3dCenter);
        return newVec;
    }

    public int putItems(int slot, @Nonnull ItemStack stack) {
        ItemStack stack1 = stack.m_41777_();
        Random rand = new Random();
        if (((ItemStack)this.items.get(slot)).m_41619_()) {
            if (stack1.m_41613_() > 2) {
                stack1.m_41764_(3);
                this.items.set(slot, (Object)stack1);
                this.sync();
                stack.m_41774_(3);
                for (int i = 0; i < 3; ++i) {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                }
            } else {
                this.items.set(slot, (Object)stack1);
                this.sync();
                stack.m_41774_(stack.m_41613_());
                for (int i = 0; i < stack1.m_41613_(); ++i) {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                }
            }
            return 1;
        }
        if (!((ItemStack)this.items.get(slot)).m_41656_(stack)) {
            return 0;
        }
        if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)this.items.get(slot)))) {
            return 0;
        }
        int count = ((ItemStack)this.items.get(slot)).m_41613_();
        if (stack1.m_41613_() > 2 - count) {
            stack1.m_41764_(3);
            this.items.set(slot, (Object)stack1);
            this.sync();
            stack.m_41774_(3 - count);
            for (int i = 0; i < 3 - count; ++i) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
            }
        } else {
            stack1.m_41764_(count + stack1.m_41613_());
            this.items.set(slot, (Object)stack1);
            this.sync();
            stack.m_41774_(stack.m_41613_());
            for (int i = 0; i < stack1.m_41613_(); ++i) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
            }
        }
        return 1;
    }

    public int interactDryingRack(Player player, BlockHitResult hit) {
        if (this.f_58857_ == null) {
            return 0;
        }
        if (!player.m_6144_()) {
            if (!player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                Random rand = new Random();
                if (((ItemStack)this.items.get(0)).m_41619_() || player.m_21120_(InteractionHand.MAIN_HAND) == this.items.get(0)) {
                    this.putItems(0, player.m_21120_(InteractionHand.MAIN_HAND));
                    this.dryingTime[0] = this.dryingTimeMax[0];
                    this.crafted[0] = false;
                    return 1;
                }
                if (ItemStack.m_150942_((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND), (ItemStack)((ItemStack)this.items.get(0))) && ((ItemStack)this.items.get(0)).m_41613_() < this.m_6893_()) {
                    this.putItems(0, player.m_21120_(InteractionHand.MAIN_HAND));
                } else {
                    if (((ItemStack)this.items.get(1)).m_41619_() || player.m_21120_(InteractionHand.MAIN_HAND) == this.items.get(1) && ((ItemStack)this.items.get(1)).m_41613_() < this.m_6893_()) {
                        this.putItems(1, player.m_21120_(InteractionHand.MAIN_HAND));
                        this.dryingTime[1] = this.dryingTimeMax[1];
                        this.crafted[1] = false;
                        return 1;
                    }
                    if (ItemStack.m_150942_((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND), (ItemStack)((ItemStack)this.items.get(1))) && ((ItemStack)this.items.get(1)).m_41613_() < this.m_6893_()) {
                        this.putItems(1, player.m_21120_(InteractionHand.MAIN_HAND));
                    } else {
                        if (((ItemStack)this.items.get(2)).m_41619_() || player.m_21120_(InteractionHand.MAIN_HAND) == this.items.get(2) && ((ItemStack)this.items.get(2)).m_41613_() < this.m_6893_()) {
                            this.putItems(2, player.m_21120_(InteractionHand.MAIN_HAND));
                            this.dryingTime[2] = this.dryingTimeMax[2];
                            this.crafted[2] = false;
                            return 1;
                        }
                        if (ItemStack.m_150942_((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND), (ItemStack)((ItemStack)this.items.get(2))) && ((ItemStack)this.items.get(2)).m_41613_() < this.m_6893_()) {
                            this.putItems(2, player.m_21120_(InteractionHand.MAIN_HAND));
                        }
                    }
                }
            }
            if (this.crafted[0]) {
                this.crafted[0] = false;
                this.dryingTime[0] = this.dryingTimeMax[0];
                player.f_36093_.m_150079_(((ItemStack)this.items.get(0)).m_41777_());
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(0, (Object)ItemStack.f_41583_);
                this.output[0] = ItemStack.f_41583_;
            }
            if (this.crafted[1]) {
                this.crafted[1] = false;
                this.dryingTime[1] = this.dryingTimeMax[1];
                player.f_36093_.m_150079_(((ItemStack)this.items.get(1)).m_41777_());
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(1, (Object)ItemStack.f_41583_);
                this.output[1] = ItemStack.f_41583_;
            }
            if (this.crafted[2]) {
                this.crafted[2] = false;
                this.dryingTime[2] = this.dryingTimeMax[2];
                player.f_36093_.m_150079_(((ItemStack)this.items.get(2)).m_41777_());
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(2, (Object)ItemStack.f_41583_);
                this.output[2] = ItemStack.f_41583_;
            }
            this.sync();
        } else {
            if (!this.crafting[0]) {
                this.crafted[0] = false;
                this.dryingTime[0] = this.dryingTimeMax[0];
                player.f_36093_.m_150079_(((ItemStack)this.items.get(0)).m_41777_());
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(0, (Object)ItemStack.f_41583_);
                this.output[0] = ItemStack.f_41583_;
                this.sync();
            }
            if (!((ItemStack)this.items.get(1)).m_41619_() && !this.crafting[1]) {
                this.crafted[1] = false;
                this.dryingTime[1] = this.dryingTimeMax[1];
                player.f_36093_.m_150079_(((ItemStack)this.items.get(1)).m_41777_());
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(1, (Object)ItemStack.f_41583_);
                this.output[1] = ItemStack.f_41583_;
                this.sync();
            }
            if (!((ItemStack)this.items.get(2)).m_41619_() && !this.crafting[2]) {
                this.crafted[2] = false;
                this.dryingTime[2] = this.dryingTimeMax[2];
                player.f_36093_.m_150079_(((ItemStack)this.items.get(2)).m_41777_());
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(2, (Object)ItemStack.f_41583_);
                this.output[2] = ItemStack.f_41583_;
                this.sync();
            }
        }
        return 0;
    }

    public void tick() {
        if (this.f_58857_ instanceof ServerLevel) {
            this.craft();
            for (int i = 0; i < 3; ++i) {
                if (((ItemStack)this.items.get(i)).m_41619_()) {
                    this.placedTime[i] = 0;
                } else {
                    int n = i;
                    this.placedTime[n] = this.placedTime[n] + 1;
                }
                if (!this.crafting[i]) continue;
                if (this.dryingTime[i] > 0) {
                    int n = i;
                    this.dryingTime[n] = this.dryingTime[n] - 1;
                }
                if (this.dryingTime[i] != 0) continue;
                this.crafted[i] = true;
                this.crafting[i] = false;
                this.craftTheItem(this.output[i], i);
            }
        }
    }

    public int[] m_7071_(Direction p_19238_) {
        return new int[]{0, 1, 2};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return ((ItemStack)this.items.get(index)).m_41619_() || ((ItemStack)this.items.get(index)).m_41613_() < this.m_6893_();
    }

    public boolean m_7157_(int p_19239_, ItemStack p_19240_, Direction p_19241_) {
        return !this.crafting[p_19239_] && this.placedTime[p_19239_] >= 20;
    }

    public int m_6643_() {
        return this.items.size();
    }
}

