/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class FileManager<T> {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Class<T> classOfT;
    private final File file;
    private final File fileDir;

    public FileManager(String filePath, Class<T> classOfT) {
        String userDir = System.getProperty("user.dir");
        this.file = new File(userDir + filePath);
        this.fileDir = new File(userDir + filePath.substring(0, filePath.lastIndexOf("/")));
        this.classOfT = classOfT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T read() {
        try (FileReader fileReader = new FileReader(this.file);){
            Object object = this.gson.fromJson((Reader)fileReader, this.classOfT);
            return (T)object;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void write(T object) {
        if (!this.fileDir.exists()) {
            this.fileDir.mkdirs();
        }
        try (FileWriter fileWriter = new FileWriter(this.file);){
            this.gson.toJson(object, (Appendable)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }
}

