/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.entity;

import dev.latvian.mods.kubejs.entity.LivingEntityEventJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;

@Info(value="Invoked before an entity is spawned into the world.\n\nOnly entities from a `BaseSpawner` or world generation will trigger this event.\n")
public class CheckLivingEntitySpawnEventJS
extends LivingEntityEventJS {
    private final LivingEntity entity;
    private final Level level;
    public final double x;
    public final double y;
    public final double z;
    public final MobSpawnType type;

    public CheckLivingEntitySpawnEventJS(LivingEntity entity, Level level, double x, double y, double z, MobSpawnType type) {
        this.entity = entity;
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    @Override
    @Info(value="The level the entity is being spawned into.")
    public Level getLevel() {
        return this.level;
    }

    @Override
    @Info(value="The entity being spawned.")
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Info(value="The block the entity is being spawned on.")
    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.level, new BlockPos(this.x, this.y, this.z));
    }

    @Info(value="The type of spawn.")
    public MobSpawnType getType() {
        return this.type;
    }
}

