/*
 * Decompiled with CFR 0.152.
 */
package ca.edtoaster.littlecontraptions.ponder;

import ca.edtoaster.littlecontraptions.entity.ContraptionBargeEntity;
import ca.edtoaster.littlecontraptions.ponder.element.VehicleElement;
import ca.edtoaster.littlecontraptions.ponder.element.VehicleInstructions;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class AssemblerScenes {
    public static void basicAssemblerScene(SceneBuilder scene, SceneBuildingUtil util) {
        VehicleInstructions bargeInst = new VehicleInstructions(scene);
        scene.title("basic_assembler", "Moving Structures using Barge Assemblers");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.9f);
        scene.world.showSection(util.select.fromTo(0, 0, 0, 1, 0, 4).add(util.select.fromTo(3, 0, 0, 4, 0, 4)), Direction.UP);
        scene.idle(5);
        for (int z = 0; z < 5; ++z) {
            scene.world.showSection(util.select.position(2, 0, z), Direction.DOWN);
            scene.idle(2);
        }
        BlockPos assemblerPos = util.grid.at(2, 1, 2);
        BlockPos leverPos = util.grid.at(0, 1, 2);
        Selection assemblySection = util.select.fromTo(assemblerPos, leverPos);
        scene.idle(17);
        scene.world.showSection(assemblySection, Direction.EAST);
        scene.idle(20);
        scene.world.toggleRedstonePower(assemblySection);
        scene.effects.indicateRedstone(leverPos);
        scene.idle(10);
        scene.overlay.showText(70).text("Powered Barge Assemblers mount attached structures to passing Contraption Barges").attachKeyFrame().pointAt(util.vector.topOf(assemblerPos)).placeNearTarget();
        scene.idle(80);
        ElementLink<VehicleElement<ContraptionBargeEntity>> barge = bargeInst.createVehicle(util.vector.topOf(2, 0, 4), 90.0f, ContraptionBargeEntity::new);
        scene.world.showSection(util.select.position(assemblerPos.m_7494_()), Direction.DOWN);
        scene.idle(10);
        bargeInst.moveVehicle(barge, util.vector.of(0.0, 0.0, -2.0), 20);
        scene.idle(20);
        ElementLink plank = scene.world.makeSectionIndependent(util.select.position(assemblerPos.m_7494_()));
        scene.effects.indicateSuccess(assemblerPos);
        scene.idle(1);
        scene.world.moveSection(plank, util.vector.of(0.0, 0.0, -2.0), 20);
        bargeInst.moveVehicle(barge, util.vector.of(0.0, 0.0, -2.0), 20);
        scene.idle(20);
        scene.world.toggleRedstonePower(assemblySection);
        scene.idle(10);
        scene.overlay.showText(70).text("Without a redstone signal, it disassembles passing barge contraptions back into blocks").colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector.topOf(assemblerPos)).placeNearTarget();
        scene.idle(80);
        scene.world.rotateSection(plank, 0.0, 180.0, 0.0, 6);
        bargeInst.rotateVehicle(barge, 180.0f, 6);
        scene.idle(3);
        scene.world.moveSection(plank, util.vector.of(0.0, 0.0, 2.0), 20);
        bargeInst.moveVehicle(barge, util.vector.of(0.0, 0.0, 2.0), 20);
        scene.idle(20);
        bargeInst.moveVehicle(barge, util.vector.of(0.0, 0.0, 2.0), 20);
        scene.idle(30);
        scene.world.destroyBlock(assemblerPos.m_7494_());
        bargeInst.rotateVehicle(barge, 180.0f, 6);
        scene.idle(10);
        scene.addKeyframe();
        ElementLink contraption = scene.world.showIndependentSection(util.select.fromTo(2, 3, 2, 4, 3, 2), Direction.DOWN);
        scene.world.moveSection(contraption, new Vec3(0.0, -1.0, 0.0), 0);
        scene.world.toggleRedstonePower(assemblySection);
        scene.effects.indicateRedstone(leverPos);
        scene.idle(10);
        scene.effects.superGlue(util.grid.at(4, 2, 1), Direction.SOUTH, true);
        scene.overlay.showText(70).text("Similar to Cart Contraptions, you can attach larger contraptions using Chassis and Super Glue").pointAt(util.vector.topOf(assemblerPos)).placeNearTarget();
        scene.idle(80);
        Selection drillPos = util.select.position(4, 3, 1);
        scene.world.showSectionAndMerge(drillPos, Direction.SOUTH, contraption);
        scene.world.configureCenterOfRotation(contraption, new Vec3(2.5, 0.0, 2.5));
        scene.idle(10);
        bargeInst.moveVehicle(barge, new Vec3(0.0, 0.0, -2.0), 20);
        scene.idle(20);
        scene.effects.indicateSuccess(assemblerPos);
        bargeInst.moveVehicle(barge, new Vec3(0.0, 0.0, -2.0), 20);
        scene.world.moveSection(contraption, new Vec3(0.0, 0.0, -2.0), 20);
        scene.world.setKineticSpeed(drillPos, 20.0f);
        scene.idle(40);
        bargeInst.rotateVehicle(barge, 180.0f, 16);
        scene.world.rotateSection(contraption, 0.0, 180.0, 0.0, 16);
        scene.idle(16);
        bargeInst.moveVehicle(barge, new Vec3(0.0, 0.0, 4.0), 40);
        scene.world.moveSection(contraption, new Vec3(0.0, 0.0, 4.0), 40);
        scene.idle(40);
        scene.world.setKineticSpeed(drillPos, 0.0f);
        scene.world.hideIndependentSection(contraption, Direction.UP);
        scene.idle(10);
    }
}

