/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.container;

import dev.murad.shipping.entity.accessor.DataAccessor;
import dev.murad.shipping.entity.accessor.HeadVehicleDataAccessor;
import dev.murad.shipping.entity.container.AbstractItemHandlerContainer;
import dev.murad.shipping.entity.custom.HeadVehicle;
import dev.murad.shipping.network.EnrollVehiclePacket;
import dev.murad.shipping.network.SetEnginePacket;
import dev.murad.shipping.network.VehiclePacketHandler;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class AbstractHeadVehicleContainer<T extends HeadVehicleDataAccessor, U extends Entity>
extends AbstractItemHandlerContainer {
    public static final ResourceLocation EMPTY_ATLAS_LOC = InventoryMenu.f_39692_;
    protected T data;
    protected U entity;
    protected Player player;

    public AbstractHeadVehicleContainer(@Nullable MenuType<?> containerType, int windowId, Level world, T data, Inventory playerInventory, Player player) {
        super(containerType, windowId, playerInventory, player);
        this.entity = world.m_6815_(((DataAccessor)data).getEntityUUID());
        this.data = data;
        this.player = playerInventory.f_35978_;
        this.layoutPlayerInventorySlots(8, 84);
        this.m_38884_((ContainerData)data);
        this.m_38897_(new SlotItemHandler((IItemHandler)((HeadVehicle)this.entity).getRouteItemHandler(), 0, 98, 57).setBackground(EMPTY_ATLAS_LOC, ((HeadVehicle)this.entity).getRouteIcon()));
    }

    @Override
    protected int getSlotNum() {
        return 2;
    }

    public boolean isLit() {
        return ((HeadVehicleDataAccessor)this.data).isLit();
    }

    public boolean isOn() {
        return ((HeadVehicleDataAccessor)this.data).isOn();
    }

    public int routeSize() {
        return ((HeadVehicleDataAccessor)this.data).routeSize();
    }

    public int visitedSize() {
        return ((HeadVehicleDataAccessor)this.data).visitedSize();
    }

    public void setEngine(boolean state) {
        VehiclePacketHandler.INSTANCE.sendToServer((Object)new SetEnginePacket(this.entity.m_19879_(), state));
    }

    public void enroll() {
        VehiclePacketHandler.INSTANCE.sendToServer((Object)new EnrollVehiclePacket(this.entity.m_19879_()));
    }

    public String getOwner() {
        return ((HeadVehicle)this.entity).owner();
    }

    public boolean canMove() {
        return ((HeadVehicleDataAccessor)this.data).canMove();
    }

    public String getRouteText() {
        return this.visitedSize() + "/" + this.routeSize();
    }

    public boolean m_6875_(Player p_75145_1_) {
        return ((HeadVehicle)this.entity).isValid(p_75145_1_);
    }
}

