/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.train.wagon;

import dev.murad.shipping.capability.StallingCapability;
import dev.murad.shipping.entity.custom.train.AbstractTrainCarEntity;
import dev.murad.shipping.entity.custom.train.locomotive.AbstractLocomotiveEntity;
import dev.murad.shipping.util.Train;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractWagonEntity
extends AbstractTrainCarEntity {
    private final StallingCapability capability = new StallingCapability(){

        @Override
        public boolean isDocked() {
            return this.delegate().map(StallingCapability::isDocked).orElse(false);
        }

        @Override
        public void dock(double x, double y, double z) {
            this.delegate().ifPresent(s -> s.dock(x, y, z));
        }

        @Override
        public void undock() {
            this.delegate().ifPresent(StallingCapability::undock);
        }

        @Override
        public boolean isStalled() {
            return this.delegate().map(StallingCapability::isStalled).orElse(false);
        }

        @Override
        public void stall() {
            this.delegate().ifPresent(StallingCapability::stall);
        }

        @Override
        public void unstall() {
            this.delegate().ifPresent(StallingCapability::unstall);
        }

        @Override
        public boolean isFrozen() {
            return AbstractWagonEntity.super.isFrozen();
        }

        @Override
        public void freeze() {
            AbstractWagonEntity.super.setFrozen(true);
        }

        @Override
        public void unfreeze() {
            AbstractWagonEntity.super.setFrozen(false);
        }

        private Optional<StallingCapability> delegate() {
            Object t = ((AbstractWagonEntity)AbstractWagonEntity.this).linkingHandler.train.getHead();
            if (t instanceof AbstractLocomotiveEntity) {
                AbstractLocomotiveEntity e = (AbstractLocomotiveEntity)t;
                return e.getCapability(StallingCapability.STALLING_CAPABILITY).resolve();
            }
            return Optional.empty();
        }
    };
    private final LazyOptional<StallingCapability> capabilityOpt = LazyOptional.of(() -> this.capability);

    public AbstractWagonEntity(EntityType<?> p_38087_, Level p_38088_) {
        super(p_38087_, p_38088_);
    }

    public AbstractWagonEntity(EntityType<?> p_38087_, Level level, Double aDouble, Double aDouble1, Double aDouble2) {
        super(p_38087_, level, aDouble, aDouble1, aDouble2);
    }

    @Override
    public void setDominated(AbstractTrainCarEntity entity) {
        this.linkingHandler.dominated = Optional.of(entity);
    }

    @Override
    public void setDominant(AbstractTrainCarEntity entity) {
        this.setTrain(entity.getTrain());
        this.linkingHandler.dominant = Optional.of(entity);
    }

    @Override
    public void m_8119_() {
        if (this.capability.isFrozen() || this.linkingHandler.train.getTug().map(s -> (AbstractLocomotiveEntity)s).map(AbstractLocomotiveEntity::shouldFreezeTrain).orElse(false).booleanValue()) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            super.m_8119_();
        }
    }

    @Override
    public void removeDominated() {
        if (!this.m_6084_()) {
            return;
        }
        this.linkingHandler.dominated = Optional.empty();
        this.linkingHandler.train.setTail(this);
    }

    @Override
    public void removeDominant() {
        if (!this.m_6084_()) {
            return;
        }
        this.linkingHandler.dominant = Optional.empty();
        this.setTrain(new Train<AbstractTrainCarEntity>(this));
    }

    @Override
    public void setTrain(Train<AbstractTrainCarEntity> train) {
        this.linkingHandler.train = train;
        train.setTail(this);
        this.linkingHandler.dominated.ifPresent(dominated -> {
            if (!dominated.getTrain().equals(train)) {
                dominated.setTrain(train);
            }
        });
    }

    public boolean isDockable() {
        return this.linkingHandler.dominant.map(dom -> this.m_20280_((Entity)dom) < 1.05).orElse(true);
    }

    @Override
    public boolean allowDockInterface() {
        return this.isDockable();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == StallingCapability.STALLING_CAPABILITY) {
            return this.capabilityOpt.cast();
        }
        return super.getCapability(cap);
    }
}

