/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.HashSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.UpdatingTileEntity;

public class InvisibleBarrierBlockTileEntity
extends UpdatingTileEntity {
    private UUID casterUUID;
    public BlockPos boundaryCircle;
    public long timeN = 21L;
    public long timeE = 21L;
    public long timeW = 21L;
    public long timeS = 21L;
    public long timeU = 21L;
    public long timeD = 21L;
    public static final int fadeTicks = 20;
    public static int updateWhiteListTicks = 20;
    public static final String CASTER_ID = "caster_uuid";
    public static final String TIME_SINCE_COLLISION = "time_since_last_collision";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_X = "original_boundary_circle_x";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_Y = "original_boundary_circle_y";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_Z = "original_boundary_circle_z";
    public static final String WHITELIST_TAG = "whitelist";
    public HashSet<UUID> whitelist;

    public InvisibleBarrierBlockTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.invisibleBarrier.get(), p, bs);
    }

    public void m_183515_(CompoundTag compound) {
        if (this.casterUUID != null) {
            compound.m_128362_(CASTER_ID, this.casterUUID);
        }
        compound.m_128356_("time_since_last_collisionN", this.timeN);
        compound.m_128356_("time_since_last_collisionE", this.timeE);
        compound.m_128356_("time_since_last_collisionW", this.timeW);
        compound.m_128356_("time_since_last_collisionS", this.timeS);
        compound.m_128356_("time_since_last_collisionU", this.timeU);
        compound.m_128356_("time_since_last_collisionD", this.timeD);
        if (this.boundaryCircle != null) {
            compound.m_128405_(ORIGINAL_BOUNDARY_CIRCLE_X, this.boundaryCircle.m_123341_());
            compound.m_128405_(ORIGINAL_BOUNDARY_CIRCLE_Y, this.boundaryCircle.m_123342_());
            compound.m_128405_(ORIGINAL_BOUNDARY_CIRCLE_Z, this.boundaryCircle.m_123343_());
        }
        if (this.whitelist != null) {
            CompoundTag tmp = new CompoundTag();
            int z = 0;
            for (UUID uuid : this.whitelist) {
                tmp.m_128362_("MAHOUTSUKAI_WHITELIST_" + z++, uuid);
            }
            compound.m_128365_(WHITELIST_TAG, (Tag)tmp);
        }
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.casterUUID = compound.m_128403_(CASTER_ID) ? compound.m_128342_(CASTER_ID) : null;
        this.timeN = compound.m_128454_("time_since_last_collisionN");
        this.timeE = compound.m_128454_("time_since_last_collisionE");
        this.timeW = compound.m_128454_("time_since_last_collisionW");
        this.timeS = compound.m_128454_("time_since_last_collisionS");
        this.timeU = compound.m_128454_("time_since_last_collisionU");
        this.timeD = compound.m_128454_("time_since_last_collisionD");
        if (compound.m_128441_(ORIGINAL_BOUNDARY_CIRCLE_X) && compound.m_128441_(ORIGINAL_BOUNDARY_CIRCLE_Y) && compound.m_128441_(ORIGINAL_BOUNDARY_CIRCLE_Z)) {
            this.boundaryCircle = new BlockPos(compound.m_128451_(ORIGINAL_BOUNDARY_CIRCLE_X), compound.m_128451_(ORIGINAL_BOUNDARY_CIRCLE_Y), compound.m_128451_(ORIGINAL_BOUNDARY_CIRCLE_Z));
        }
        if (compound.m_128441_(WHITELIST_TAG)) {
            CompoundTag nbt;
            if (this.whitelist == null) {
                this.whitelist = new HashSet();
            }
            if ((nbt = (CompoundTag)compound.m_128423_(WHITELIST_TAG)) != null) {
                for (String s : nbt.m_128431_()) {
                    this.whitelist.add(nbt.m_128342_(s));
                }
            }
        }
        super.m_142466_(compound);
    }

    public long getTimeSinceCollision(Direction facing) {
        if (this.f_58857_ != null) {
            if (facing == Direction.NORTH) {
                return this.f_58857_.m_46467_() - this.timeN;
            }
            if (facing == Direction.EAST) {
                return this.f_58857_.m_46467_() - this.timeE;
            }
            if (facing == Direction.WEST) {
                return this.f_58857_.m_46467_() - this.timeW;
            }
            if (facing == Direction.SOUTH) {
                return this.f_58857_.m_46467_() - this.timeS;
            }
            if (facing == Direction.DOWN) {
                return this.f_58857_.m_46467_() - this.timeD;
            }
            if (facing == Direction.UP) {
                return this.f_58857_.m_46467_() - this.timeU;
            }
        }
        return 21L;
    }

    public void setTimeOfCollision(long t, Direction facing) {
        if (facing == Direction.NORTH) {
            this.timeN = t;
        }
        if (facing == Direction.EAST) {
            this.timeE = t;
        }
        if (facing == Direction.WEST) {
            this.timeW = t;
        }
        if (facing == Direction.SOUTH) {
            this.timeS = t;
        }
        if (facing == Direction.DOWN) {
            this.timeD = t;
        }
        if (facing == Direction.UP) {
            this.timeU = t;
        }
        this.sendUpdates();
    }

    public Player getCaster() {
        try {
            Player caster = this.f_58857_.m_46003_(this.casterUUID);
            return caster;
        }
        catch (Exception e) {
            return null;
        }
    }

    public UUID getCasterUUID() {
        return this.casterUUID;
    }

    public void setCasterUUID(UUID casterUUID) {
        this.casterUUID = casterUUID;
        this.sendUpdates();
    }

    public void setBoundaryCircle(BlockPos p) {
        this.boundaryCircle = p;
        this.sendUpdates();
    }

    public void setCaster(Player caster) {
        this.casterUUID = caster.m_20148_();
        this.sendUpdates();
    }
}

