/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.definition;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.blockentity.crafting.CraftingMonitorBlockEntity;
import appeng.blockentity.networking.EnergyCellBlockEntity;
import appeng.core.definitions.BlockDefinition;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import gripe._90.megacells.block.entity.MEGAPatternProviderBlockEntity;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.util.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public final class MEGABlockEntities {
    private static final Map<ResourceLocation, BlockEntityType<?>> BLOCK_ENTITY_TYPES = new HashMap();
    public static final BlockEntityType<EnergyCellBlockEntity> MEGA_ENERGY_CELL = MEGABlockEntities.create("mega_energy_cell", EnergyCellBlockEntity.class, EnergyCellBlockEntity::new, MEGABlocks.MEGA_ENERGY_CELL);
    public static final BlockEntityType<CraftingBlockEntity> MEGA_CRAFTING_UNIT = MEGABlockEntities.create("mega_crafting_unit", CraftingBlockEntity.class, CraftingBlockEntity::new, MEGABlocks.MEGA_CRAFTING_UNIT, MEGABlocks.CRAFTING_ACCELERATOR);
    public static final BlockEntityType<CraftingBlockEntity> MEGA_CRAFTING_STORAGE = MEGABlockEntities.create("mega_crafting_storage", CraftingBlockEntity.class, CraftingBlockEntity::new, MEGABlocks.CRAFTING_STORAGE_1M, MEGABlocks.CRAFTING_STORAGE_4M, MEGABlocks.CRAFTING_STORAGE_16M, MEGABlocks.CRAFTING_STORAGE_64M, MEGABlocks.CRAFTING_STORAGE_256M);
    public static final BlockEntityType<CraftingMonitorBlockEntity> MEGA_CRAFTING_MONITOR = MEGABlockEntities.create("mega_crafting_monitor", CraftingMonitorBlockEntity.class, CraftingMonitorBlockEntity::new, MEGABlocks.CRAFTING_MONITOR);
    public static final BlockEntityType<MEGAPatternProviderBlockEntity> MEGA_PATTERN_PROVIDER = MEGABlockEntities.create("mega_pattern_provider", MEGAPatternProviderBlockEntity.class, MEGAPatternProviderBlockEntity::new, MEGABlocks.MEGA_PATTERN_PROVIDER);

    public static void init() {
        Utils.LOGGER.info("Initialised block entities.");
    }

    public static Map<ResourceLocation, BlockEntityType<?>> getBlockEntityTypes() {
        return ImmutableMap.copyOf(BLOCK_ENTITY_TYPES);
    }

    @SafeVarargs
    private static <T extends AEBaseBlockEntity> BlockEntityType<T> create(String id, Class<T> entityClass, BlockEntityFactory<T> factory, BlockDefinition<? extends AEBaseEntityBlock<?>> ... blockDefinitions) {
        Preconditions.checkArgument((blockDefinitions.length > 0 ? 1 : 0) != 0);
        AEBaseEntityBlock[] blocks = (AEBaseEntityBlock[])Arrays.stream(blockDefinitions).map(BlockDefinition::block).toArray(AEBaseEntityBlock[]::new);
        AtomicReference<BlockEntityType> typeHolder = new AtomicReference<BlockEntityType>();
        BlockEntityType.BlockEntitySupplier supplier = (blockPos, blockState) -> factory.create((BlockEntityType)typeHolder.get(), blockPos, blockState);
        BlockEntityType type = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)supplier, (Block[])blocks).m_58966_(null);
        typeHolder.set(type);
        BLOCK_ENTITY_TYPES.put(Utils.makeId(id), type);
        AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)type, (Item)blockDefinitions[0].m_5456_());
        AEBaseEntityBlock[] aEBaseEntityBlockArray = blocks;
        int n = aEBaseEntityBlockArray.length;
        for (int i = 0; i < n; ++i) {
            AEBaseEntityBlock block;
            AEBaseEntityBlock baseBlock = block = aEBaseEntityBlockArray[i];
            baseBlock.setBlockEntity(entityClass, type, null, null);
        }
        return type;
    }

    @FunctionalInterface
    static interface BlockEntityFactory<T extends AEBaseBlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

