/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.part;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.items.parts.PartModels;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import gripe._90.megacells.crafting.DecompressionPatternDecoder;
import gripe._90.megacells.crafting.MEGADecompressionPattern;
import gripe._90.megacells.service.DecompressionService;
import gripe._90.megacells.util.Utils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class DecompressionModulePart
extends AEBasePart
implements ICraftingProvider,
IGridTickable {
    @PartModels
    public static final IPartModel MODEL = new PartModel(Utils.makeId("part/decompression_module"));
    private final List<IPatternDetails> patterns = new ObjectArrayList();
    private final Object2LongMap<AEKey> outputs = new Object2LongOpenHashMap();

    public DecompressionModulePart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).addService(IGridTickable.class, (IGridNodeService)this).addService(ICraftingProvider.class, (IGridNodeService)this).setIdlePowerUsage(10.0);
    }

    public List<IPatternDetails> getAvailablePatterns() {
        return this.patterns;
    }

    public int getPatternPriority() {
        return Integer.MAX_VALUE;
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!this.getMainNode().isActive() || !(patternDetails instanceof MEGADecompressionPattern)) {
            return false;
        }
        MEGADecompressionPattern pattern = (MEGADecompressionPattern)patternDetails;
        GenericStack output = pattern.getPrimaryOutput();
        this.outputs.mergeLong((Object)output.what(), output.amount(), Long::sum);
        return true;
    }

    public boolean isBusy() {
        return !this.outputs.isEmpty();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 12.0, 13.0, 13.0, 16.0);
        bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 12.0);
    }

    public IPartModel getStaticModels() {
        return MODEL;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 1, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.patterns.clear();
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            DecompressionService decompressionService = (DecompressionService)grid.getService(DecompressionService.class);
            for (Object2IntMap<AEItemKey> chain : decompressionService.getDecompressionChains()) {
                Set<AEItemKey> patternItems = decompressionService.getDecompressionPatterns(chain);
                Stream<MEGADecompressionPattern> decodedPatterns = patternItems.stream().map(p -> DecompressionPatternDecoder.INSTANCE.decodePattern((AEItemKey)p, this.getLevel()));
                this.patterns.addAll(decodedPatterns.toList());
            }
            IStorageService storage = grid.getStorageService();
            for (Object2LongMap.Entry output : this.outputs.object2LongEntrySet()) {
                AEKey what = (AEKey)output.getKey();
                long amount = output.getLongValue();
                long inserted = storage.getInventory().insert(what, amount, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)this));
                if (inserted >= amount) {
                    this.outputs.removeLong((Object)what);
                    continue;
                }
                if (inserted <= 0L) continue;
                this.outputs.put((Object)what, amount - inserted);
            }
            ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
        }
        return TickRateModulation.URGENT;
    }
}

