/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeBreakType;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeColor;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class MiningVisualsScreen
extends Screen {
    private ItemStack gadget;
    private Button blockBreakButton;
    private int red;
    private int green;
    private int blue;
    private int red_inner;
    private int green_inner;
    private int blue_inner;
    private ForgeSlider sliderRedInner;
    private ForgeSlider sliderGreenInner;
    private ForgeSlider sliderBlueInner;
    private ForgeSlider sliderRedOuter;
    private ForgeSlider sliderGreenOuter;
    private ForgeSlider sliderBlueOuter;
    private Map<ForgeSlider, IntConsumer> sliderMap = new HashMap<ForgeSlider, IntConsumer>();

    public MiningVisualsScreen(ItemStack gadget) {
        super((Component)Component.m_237113_((String)"title"));
        this.gadget = gadget;
        this.red = MiningProperties.getColor(gadget, "colorRed");
        this.green = MiningProperties.getColor(gadget, "colorGreen");
        this.blue = MiningProperties.getColor(gadget, "colorBlue");
        this.red_inner = MiningProperties.getColor(gadget, "colorRedInner");
        this.green_inner = MiningProperties.getColor(gadget, "colorGreenInner");
        this.blue_inner = MiningProperties.getColor(gadget, "colorBlueInner");
    }

    protected void m_7856_() {
        int baseX = this.f_96543_ / 2;
        int baseY = this.f_96544_ / 2;
        MutableComponent buttonText = MiningProperties.getBreakType(this.gadget) == MiningProperties.BreakTypes.SHRINK ? Component.m_237115_((String)"mininggadgets.tooltip.screen.shrink") : Component.m_237115_((String)"mininggadgets.tooltip.screen.fade");
        this.blockBreakButton = new Button(baseX - 150, baseY - 55, 150, 20, (Component)buttonText, button -> {
            if (this.blockBreakButton.m_6035_().getString().contains("Shrink")) {
                button.m_93666_((Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.fade"));
            } else {
                button.m_93666_((Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.shrink"));
            }
            PacketHandler.sendToServer(new PacketChangeBreakType());
        });
        this.m_142416_((GuiEventListener)this.blockBreakButton);
        this.sliderRedInner = new ForgeSlider(baseX - 150, baseY - 10, 150, 20, (Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.red").m_130946_(": "), (Component)Component.m_237119_(), 0.0, 255.0, this.red, true){

            protected void m_5697_() {
                MiningVisualsScreen.this.red_inner = this.getValueInt();
            }
        };
        this.sliderGreenInner = new ForgeSlider(baseX - 150, baseY + 15, 150, 20, (Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.green").m_130946_(": "), (Component)Component.m_237119_(), 0.0, 255.0, this.green, true){

            protected void m_5697_() {
                MiningVisualsScreen.this.green_inner = this.getValueInt();
            }
        };
        this.sliderBlueInner = new ForgeSlider(baseX - 150, baseY + 40, 150, 20, (Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.blue").m_130946_(": "), (Component)Component.m_237119_(), 0.0, 255.0, this.blue, true){

            protected void m_5697_() {
                MiningVisualsScreen.this.blue_inner = this.getValueInt();
            }
        };
        this.sliderRedOuter = new ForgeSlider(baseX + 25, baseY - 10, 150, 20, (Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.red").m_130946_(": "), (Component)Component.m_237119_(), 0.0, 255.0, this.red_inner, true){

            protected void m_5697_() {
                MiningVisualsScreen.this.red = this.getValueInt();
            }
        };
        this.sliderGreenOuter = new ForgeSlider(baseX + 25, baseY + 15, 150, 20, (Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.green").m_130946_(": "), (Component)Component.m_237119_(), 0.0, 255.0, this.green_inner, true){

            protected void m_5697_() {
                MiningVisualsScreen.this.green = this.getValueInt();
            }
        };
        this.sliderBlueOuter = new ForgeSlider(baseX + 25, baseY + 40, 150, 20, (Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.blue").m_130946_(": "), (Component)Component.m_237119_(), 0.0, 255.0, this.blue_inner, true){

            protected void m_5697_() {
                MiningVisualsScreen.this.blue = this.getValueInt();
            }
        };
        this.m_142416_((GuiEventListener)this.sliderRedInner);
        this.m_142416_((GuiEventListener)this.sliderGreenInner);
        this.m_142416_((GuiEventListener)this.sliderBlueInner);
        this.m_142416_((GuiEventListener)this.sliderRedOuter);
        this.m_142416_((GuiEventListener)this.sliderGreenOuter);
        this.m_142416_((GuiEventListener)this.sliderBlueOuter);
        this.sliderMap = Map.of(this.sliderRedInner, a -> {
            this.red_inner = a;
        }, this.sliderGreenInner, a -> {
            this.green_inner = a;
        }, this.sliderBlueInner, a -> {
            this.blue_inner = a;
        }, this.sliderRedOuter, a -> {
            this.red = a;
        }, this.sliderGreenOuter, a -> {
            this.green = a;
        }, this.sliderBlueOuter, a -> {
            this.blue = a;
        });
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        MiningVisualsScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.visual_settings"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 95), (int)0xFFFFFF);
        MiningVisualsScreen.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.block_break_style"), (int)(this.f_96543_ / 2 - 150), (int)(this.f_96544_ / 2 - 70), (int)0xFFFFFF);
        MiningVisualsScreen.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.beam_preview"), (int)(this.f_96543_ / 2 + 25), (int)(this.f_96544_ / 2 - 70), (int)0xFFFFFF);
        MiningVisualsScreen.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.inner_color"), (int)(this.f_96543_ / 2 - 150), (int)(this.f_96544_ / 2 - 25), (int)0xFFFFFF);
        MiningVisualsScreen.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"mininggadgets.tooltip.screen.outer_color"), (int)(this.f_96543_ / 2 + 25), (int)(this.f_96544_ / 2 - 25), (int)0xFFFFFF);
        stack.m_85836_();
        MiningVisualsScreen.m_93172_((PoseStack)stack, (int)(this.f_96543_ / 2 + 25), (int)(this.f_96544_ / 2 - 55), (int)(this.f_96543_ / 2 + 25 + 150), (int)(this.f_96544_ / 2 - 55 + 20), (int)this.rgbToInt(this.red, this.green, this.blue));
        MiningVisualsScreen.m_93172_((PoseStack)stack, (int)(this.f_96543_ / 2 + 25), (int)(this.f_96544_ / 2 - 50), (int)(this.f_96543_ / 2 + 25 + 150), (int)(this.f_96544_ / 2 - 50 + 10), (int)this.rgbToInt(this.red_inner, this.green_inner, this.blue_inner));
        stack.m_85849_();
    }

    private int rgbToInt(int r, int g, int b) {
        int red = r << 16 & 0xFF0000;
        int green = g << 8 & 0xFF00;
        int blue = b & 0xFF;
        return 0xFF000000 | red | green | blue;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.sliderMap.forEach((slider, consumer) -> {
            if (slider.m_5953_(mouseX, mouseY)) {
                slider.m_93611_((double)(slider.getValueInt() + (delta > 0.0 ? 1 : -1)));
                consumer.accept(slider.getValueInt());
            }
        });
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
    }

    private void syncColors() {
        PacketHandler.sendToServer(new PacketChangeColor(this.red, this.green, this.blue, this.red_inner, this.green_inner, this.blue_inner));
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256) {
            this.syncColors();
            ModScreens.openGadgetSettingsScreen(this.gadget);
            return true;
        }
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.syncColors();
            this.m_7861_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

