/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.datagen;

import com.google.gson.JsonElement;
import com.klikli_dev.modonomicon.Modonomicon;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AdvancementsGenerator
implements DataProvider {
    private final DataGenerator generator;
    private final Map<ResourceLocation, Advancement> advancements;

    public AdvancementsGenerator(DataGenerator generator) {
        this.generator = generator;
        this.advancements = new HashMap<ResourceLocation, Advancement>();
    }

    private static Path getPath(Path path, Advancement advancement) {
        ResourceLocation id = advancement.m_138327_();
        return path.resolve("data/" + id.m_135827_() + "/advancements/" + id.m_135815_() + ".json");
    }

    private static MutableComponent text(String name, String type) {
        return Component.m_237115_((String)("advancements.modonomicon." + name + "." + type));
    }

    public static MutableComponent title(String name) {
        return AdvancementsGenerator.text(name, "title");
    }

    public static MutableComponent descr(String name) {
        return AdvancementsGenerator.text(name, "description");
    }

    private void start() {
        Advancement root = this.add(Advancement.Builder.m_138353_().m_138386_("modonomicon_present", (CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(CriteriaTriggers.f_10589_.m_7295_(), EntityPredicate.Composite.f_36667_)).m_138403_(new ResourceLocation("modonomicon", "modonomicon/root")));
    }

    private Advancement add(Advancement advancement) {
        if (this.advancements.containsKey(advancement.m_138327_())) {
            throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
        }
        this.advancements.put(advancement.m_138327_(), advancement);
        return advancement;
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        Path folder = this.generator.m_123916_();
        this.start();
        for (Advancement advancement : this.advancements.values()) {
            Path path = AdvancementsGenerator.getPath(folder, advancement);
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path);
            }
            catch (IOException exception) {
                Modonomicon.LOGGER.error("Couldn't save advancement {}", (Object)path, (Object)exception);
            }
        }
    }

    public String m_6055_() {
        return "Advancements: modonomicon";
    }
}

