/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import me.desht.modularrouters.client.gui.module.AbstractModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.logic.compiled.CompiledVacuumModule;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class VacuumModuleScreen
extends AbstractModuleScreen {
    private XPTypeButton xpb;
    private EjectButton ejb;

    public VacuumModuleScreen(ModuleMenu container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        CompiledVacuumModule vac = new CompiledVacuumModule(null, this.moduleItemStack);
        ItemStack[] icons = (ItemStack[])Arrays.stream(XPCollection.XPCollectionType.values()).map(XPCollection.XPCollectionType::getIcon).toArray(ItemStack[]::new);
        this.xpb = new XPTypeButton(this.f_97735_ + 170, this.f_97736_ + 28, 16, 16, true, icons, vac.getXPCollectionType());
        this.m_142416_((GuiEventListener)this.xpb);
        this.ejb = new EjectButton(this.f_97735_ + 167, this.f_97736_ + 48, vac.isAutoEjecting());
        this.m_142416_((GuiEventListener)this.ejb);
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 125, this.f_97736_ + 24, this.f_97735_ + 187, this.f_97736_ + 45, "modularrouters.guiText.popup.xpVacuum", guiContainer -> this.xpb.f_93624_);
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 125, this.f_97736_ + 46, this.f_97735_ + 187, this.f_97736_ + 65, "modularrouters.guiText.popup.xpVacuum.eject", guiContainer -> this.xpb.f_93624_);
    }

    @Override
    protected void setupButtonVisibility() {
        super.setupButtonVisibility();
        this.xpb.f_93624_ = this.augmentCounter.getAugmentCount((Item)ModItems.XP_VACUUM_AUGMENT.get()) > 0;
        this.ejb.f_93624_ = this.xpb.f_93624_ && !((XPCollection.XPCollectionType)((Object)this.xpb.getState())).isSolid();
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        if (this.augmentCounter.getAugmentCount((Item)ModItems.XP_VACUUM_AUGMENT.get()) > 0) {
            this.f_96547_.m_92889_(matrixStack, (Component)ClientUtil.xlate("modularrouters.guiText.label.xpVacuum", new Object[0]), 127.0f, 32.0f, 0xFFFFFF);
            if (!((XPCollection.XPCollectionType)((Object)this.xpb.getState())).isSolid()) {
                this.f_96547_.m_92889_(matrixStack, (Component)ClientUtil.xlate("modularrouters.guiText.label.xpVacuum.eject", new Object[0]), 127.0f, 52.0f, 0xFFFFFF);
            }
        }
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        if (this.augmentCounter.getAugmentCount((Item)ModItems.XP_VACUUM_AUGMENT.get()) > 0) {
            this.m_93228_(matrixStack, this.f_97735_ + 168, this.f_97736_ + 26, BUTTON_XY.x(), BUTTON_XY.y(), 18, 18);
        }
    }

    @Override
    protected CompoundTag buildMessageData() {
        CompoundTag compound = super.buildMessageData();
        compound.m_128405_("XPFluidType", ((XPCollection.XPCollectionType)((Object)this.xpb.getState())).ordinal());
        compound.m_128379_("AutoEject", this.ejb.isToggled());
        return compound;
    }

    private class XPTypeButton
    extends ItemStackCyclerButton<XPCollection.XPCollectionType> {
        private final List<List<Component>> tips;

        XPTypeButton(int x, int y, int width, int height, boolean flat, ItemStack[] stacks, XPCollection.XPCollectionType initialVal) {
            super(x, y, width, height, flat, stacks, initialVal, VacuumModuleScreen.this);
            this.tips = Lists.newArrayList();
            for (XPCollection.XPCollectionType type : XPCollection.XPCollectionType.values()) {
                MutableComponent modName = Component.m_237113_((String)ModNameCache.getModName(type.getModId()));
                MutableComponent title = type.getDisplayName().m_6879_();
                this.tips.add((List<Component>)ImmutableList.of((Object)title, (Object)modName.m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
            }
        }

        @Override
        public void setState(XPCollection.XPCollectionType newState) {
            super.setState(newState);
            VacuumModuleScreen.this.ejb.f_93624_ = VacuumModuleScreen.this.xpb.f_93624_ && !((XPCollection.XPCollectionType)((Object)VacuumModuleScreen.this.xpb.getState())).isSolid();
        }

        @Override
        public List<Component> getTooltip() {
            return this.tips.get(((XPCollection.XPCollectionType)((Object)this.getState())).ordinal());
        }

        @Override
        public boolean isApplicable(XPCollection.XPCollectionType state) {
            return state.isAvailable();
        }
    }

    private class EjectButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(112, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(192, 16);

        EjectButton(int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, VacuumModuleScreen.this);
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }
}

