/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.bitwise_logic;

import commoble.morered.MoreRed;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class ChanneledPowerStorageBlockEntity
extends BlockEntity
implements ChanneledPowerSupplier {
    public static final String POWER = "power";
    protected byte[] power = new byte[16];
    protected LazyOptional<ChanneledPowerSupplier> powerHolder = LazyOptional.of(() -> this);

    public static ChanneledPowerStorageBlockEntity create(BlockPos pos, BlockState state) {
        return new ChanneledPowerStorageBlockEntity((BlockEntityType<? extends ChanneledPowerStorageBlockEntity>)((BlockEntityType)MoreRed.instance().bitwiseLogicGateBeType.get()), pos, state);
    }

    public ChanneledPowerStorageBlockEntity(BlockEntityType<? extends ChanneledPowerStorageBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ChanneledPowerStorageBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends ChanneledPowerStorageBlockEntity>)((BlockEntityType)MoreRed.instance().bitwiseLogicGateBeType.get()), pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == MoreRedAPI.CHANNELED_POWER_CAPABILITY) {
            return side == PlateBlockStateProperties.getOutputDirection(this.m_58900_()) ? this.powerHolder : LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.powerHolder.invalidate();
    }

    public void resetCapabilities() {
        LazyOptional<ChanneledPowerSupplier> oldPowerHolder = this.powerHolder;
        this.powerHolder = LazyOptional.of(() -> this);
        oldPowerHolder.invalidate();
    }

    @Override
    public int getPowerOnChannel(Level level, BlockPos wirePos, BlockState wireState, Direction wireFace, int channel) {
        BlockState thisState = this.m_58900_();
        return wireFace == null || thisState.m_60734_() instanceof PlateBlock && wireFace == thisState.m_61143_((Property)PlateBlock.ATTACHMENT_DIRECTION) ? this.getPower(channel) : 0;
    }

    public int getPower(int channel) {
        return this.power[channel];
    }

    public boolean setPower(byte[] newPowers) {
        boolean updated = false;
        for (int i = 0; i < 16; ++i) {
            byte newPower = newPowers[i];
            byte oldPower = this.power[i];
            if (newPower == oldPower) continue;
            this.power[i] = newPower;
            updated = true;
        }
        if (updated && !this.f_58857_.f_46443_) {
            this.m_6596_();
            return true;
        }
        return false;
    }

    public boolean setPower(int channel, int newPower) {
        byte oldPower = this.power[channel];
        this.power[channel] = (byte)newPower;
        if (oldPower != newPower) {
            if (!this.f_58857_.f_46443_) {
                this.m_6596_();
            }
            return true;
        }
        return false;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128382_(POWER, (byte[])this.power.clone());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        byte[] newPower = compound.m_128463_(POWER);
        if (newPower.length == 16) {
            this.power = (byte[])newPower.clone();
        }
    }

    public void updatePower() {
        byte[] powers = this.getStrongestNeighborPower();
        this.setPower(powers);
    }

    public byte[] getStrongestNeighborPower() {
        return new byte[16];
    }
}

