/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.plate_blocks;

import commoble.morered.plate_blocks.InputSide;
import commoble.morered.plate_blocks.InputState;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.util.BlockStateUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.Tags;

public abstract class RedstonePlateBlock
extends PlateBlock {
    public static final int OUTPUT_STRENGTH = 15;
    public static final int TICK_DELAY = 1;

    public RedstonePlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract InputSide[] getInputSides();

    public abstract void notifyNeighbors(Level var1, BlockPos var2, BlockState var3);

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.hasInputPower(level, state, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = super.m_5573_(context);
        for (InputSide side : this.getInputSides()) {
            state = (BlockState)state.m_61124_((Property)side.property, (Comparable)Boolean.valueOf(side.isBlockReceivingPower(world, state, pos)));
        }
        return state;
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isPlayerHoldingStick = player.m_21120_(hand).m_204117_(Tags.Items.RODS_WOODEN);
        if (isPlayerHoldingStick && !level.f_46443_) {
            int newRotation = ((Integer)state.m_61143_((Property)ROTATION) + 1) % 4;
            BlockState newState = (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(newRotation));
            for (InputSide side : this.getInputSides()) {
                newState = (BlockState)newState.m_61124_((Property)side.property, (Comparable)Boolean.valueOf(side.isBlockReceivingPower(level, newState, pos)));
            }
            level.m_46597_(pos, newState);
        }
        return isPlayerHoldingStick ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Deprecated
    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        if (side == null) {
            return false;
        }
        Direction primaryOutputDirection = PlateBlockStateProperties.getOutputDirection(state);
        if (side == primaryOutputDirection.m_122424_()) {
            return true;
        }
        Direction attachmentDirection = (Direction)state.m_61143_((Property)PlateBlockStateProperties.ATTACHMENT_DIRECTION);
        int baseRotation = (Integer)state.m_61143_((Property)PlateBlockStateProperties.ROTATION);
        for (InputSide inputSide : this.getInputSides()) {
            Direction inputDirection = BlockStateUtil.getInputDirection(attachmentDirection, baseRotation, inputSide.rotationsFromOutput);
            if (side != inputDirection.m_122424_()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockState.m_60746_(blockAccess, pos, side);
    }

    @Deprecated
    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        this.notifyNeighbors(worldIn, pos, state);
    }

    @Deprecated
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.m_60734_() != newState.m_60734_()) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
            this.notifyNeighbors(worldIn, pos, state);
        }
    }

    @Deprecated
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        InputState oldInputState = InputState.getInput(state);
        InputState newInputState = InputState.getWorldPowerState(worldIn, state, pos);
        if (oldInputState != newInputState && !worldIn.m_183326_().m_183588_(pos, (Object)this)) {
            worldIn.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
        }
    }

    public boolean hasInputPower(Level world, BlockState state, BlockPos pos) {
        for (InputSide side : this.getInputSides()) {
            if (!side.isBlockReceivingPower(world, state, pos)) continue;
            return true;
        }
        return false;
    }
}

