/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import commoble.morered.client.ClientPacketHandlers;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class WireBreakPacket {
    public final Vec3 start;
    public final Vec3 end;

    public WireBreakPacket(Vec3 start, Vec3 end) {
        this.start = start;
        this.end = end;
    }

    public void write(FriendlyByteBuf buffer) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128347_("startX", this.start.f_82479_);
        nbt.m_128347_("startY", this.start.f_82480_);
        nbt.m_128347_("startZ", this.start.f_82481_);
        nbt.m_128347_("endX", this.end.f_82479_);
        nbt.m_128347_("endY", this.end.f_82480_);
        nbt.m_128347_("endZ", this.end.f_82481_);
        buffer.m_130079_(nbt);
    }

    public static WireBreakPacket read(FriendlyByteBuf buffer) {
        CompoundTag nbt = buffer.m_130260_();
        if (nbt == null) {
            return new WireBreakPacket(Vec3.f_82478_, Vec3.f_82478_);
        }
        Vec3 start = new Vec3(nbt.m_128459_("startX"), nbt.m_128459_("startY"), nbt.m_128459_("startZ"));
        Vec3 end = new Vec3(nbt.m_128459_("endX"), nbt.m_128459_("endY"), nbt.m_128459_("endZ"));
        return new WireBreakPacket(start, end);
    }

    public void handle(Supplier<NetworkEvent.Context> contextGetter) {
        NetworkEvent.Context context = contextGetter.get();
        context.enqueueWork(() -> ClientPacketHandlers.onWireBreakPacket(context, this));
        context.setPacketHandled(true);
    }
}

