/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.forge;

import com.starfish_studios.naturalist.Naturalist;
import com.starfish_studios.naturalist.entity.Alligator;
import com.starfish_studios.naturalist.entity.Bear;
import com.starfish_studios.naturalist.entity.Bird;
import com.starfish_studios.naturalist.entity.Boar;
import com.starfish_studios.naturalist.entity.Butterfly;
import com.starfish_studios.naturalist.entity.Caterpillar;
import com.starfish_studios.naturalist.entity.Catfish;
import com.starfish_studios.naturalist.entity.Deer;
import com.starfish_studios.naturalist.entity.Dragonfly;
import com.starfish_studios.naturalist.entity.Duck;
import com.starfish_studios.naturalist.entity.Elephant;
import com.starfish_studios.naturalist.entity.Firefly;
import com.starfish_studios.naturalist.entity.Giraffe;
import com.starfish_studios.naturalist.entity.Hippo;
import com.starfish_studios.naturalist.entity.Lion;
import com.starfish_studios.naturalist.entity.Lizard;
import com.starfish_studios.naturalist.entity.LizardTail;
import com.starfish_studios.naturalist.entity.Rhino;
import com.starfish_studios.naturalist.entity.Snail;
import com.starfish_studios.naturalist.entity.Snake;
import com.starfish_studios.naturalist.entity.Tortoise;
import com.starfish_studios.naturalist.entity.Vulture;
import com.starfish_studios.naturalist.platform.forge.CommonPlatformHelperImpl;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.forge.NaturalistBiomeModifiers;
import com.starfish_studios.naturalist.registry.forge.NaturalistConfigForge;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="naturalist")
public class NaturalistForge {
    public NaturalistForge() {
        Naturalist.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NaturalistConfigForge.COMMON_CONFIG, "naturalist.toml");
        NaturalistConfigForge.loadConfig(NaturalistConfigForge.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("naturalist.toml").toString());
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CommonPlatformHelperImpl.BLOCKS.register(bus);
        CommonPlatformHelperImpl.ITEMS.register(bus);
        CommonPlatformHelperImpl.SOUND_EVENTS.register(bus);
        CommonPlatformHelperImpl.ENTITY_TYPES.register(bus);
        CommonPlatformHelperImpl.POTIONS.register(bus);
        NaturalistBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(bus);
        bus.addListener(this::setup);
        bus.addListener(this::createAttributes);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Naturalist.registerBrewingRecipes();
            Naturalist.registerCompostables();
            Naturalist.registerSpawnPlacements();
            Naturalist.registerDispenserBehaviors();
        });
    }

    private void createAttributes(EntityAttributeCreationEvent event) {
        event.put(NaturalistEntityTypes.SNAIL.get(), Snail.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BEAR.get(), Bear.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BUTTERFLY.get(), Butterfly.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.FIREFLY.get(), Firefly.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.SNAKE.get(), Snake.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CORAL_SNAKE.get(), Snake.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.RATTLESNAKE.get(), Snake.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.DEER.get(), Deer.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BLUEJAY.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CANARY.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CARDINAL.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.ROBIN.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CATERPILLAR.get(), Caterpillar.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.RHINO.get(), Rhino.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.LION.get(), Lion.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.ELEPHANT.get(), Elephant.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.ZEBRA.get(), AbstractHorse.m_30627_().m_22265_());
        event.put(NaturalistEntityTypes.GIRAFFE.get(), Giraffe.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.HIPPO.get(), Hippo.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.VULTURE.get(), Vulture.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BOAR.get(), Boar.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.DRAGONFLY.get(), Dragonfly.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CATFISH.get(), Catfish.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.ALLIGATOR.get(), Alligator.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BASS.get(), AbstractFish.m_27495_().m_22265_());
        event.put(NaturalistEntityTypes.LIZARD.get(), Lizard.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.LIZARD_TAIL.get(), LizardTail.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.TORTOISE.get(), Tortoise.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.DUCK.get(), Duck.createAttributes().m_22265_());
    }
}

