/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.behaviour;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.util.StorageUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class ReplantSaplingBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final double REPLANT_RANGE_SQUARE = Math.pow(2.5, 2.0);
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(OccultismMemoryTypes.LAST_FELLED_TREE.get(), (Object)MemoryStatus.VALUE_PRESENT)});

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        BlockPos treePos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.LAST_FELLED_TREE.get());
        double dist = entity.m_20238_(Vec3.m_82512_((Vec3i)treePos));
        return StorageUtil.getFirstMatchingSlot((IItemHandler)((SpiritEntity)entity).itemStackHandler.orElseThrow(ItemHandlerMissingException::new), (TagKey<Item>)ItemTags.f_13180_) != -1 && dist <= REPLANT_RANGE_SQUARE;
    }

    protected void start(E entity) {
        BlockPos lastFelledTree = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.LAST_FELLED_TREE.get());
        if (((SpiritEntity)entity).f_19853_.m_46859_(lastFelledTree)) {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new BlockPosTracker(lastFelledTree));
            ItemStackHandler handler = (ItemStackHandler)((SpiritEntity)entity).itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
            ItemStack sapling = handler.getStackInSlot(StorageUtil.getFirstMatchingSlot((IItemHandler)handler, (TagKey<Item>)ItemTags.f_13180_));
            Item item = sapling.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem saplingBlockItem = (BlockItem)item;
                ((SpiritEntity)entity).f_19853_.m_46597_(lastFelledTree, saplingBlockItem.m_40614_().m_49966_());
                sapling.m_41774_(1);
            }
        }
        BrainUtils.clearMemory(entity, OccultismMemoryTypes.LAST_FELLED_TREE.get());
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

