/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BlockEntityUtil {
    public static boolean isLoaded(Level level, GlobalBlockPos pos) {
        if (pos == null) {
            return false;
        }
        if (level.m_46472_() == pos.getDimensionKey()) {
            return level.m_46749_(pos.getPos());
        }
        if (level.f_46443_) {
            return false;
        }
        ServerLevel dimensionWorld = ServerLifecycleHooks.getCurrentServer().m_129880_(pos.getDimensionKey());
        if (dimensionWorld != null) {
            return dimensionWorld.m_46749_(pos.getPos());
        }
        return false;
    }

    public static BlockEntity get(Level level, GlobalBlockPos pos) {
        if (pos == null) {
            return null;
        }
        if (level.m_46472_() == pos.getDimensionKey()) {
            return BlockEntityUtil.getWorldTileEntityUnchecked(level, pos.getPos());
        }
        if (level.f_46443_) {
            return null;
        }
        ServerLevel dimensionWorld = ServerLifecycleHooks.getCurrentServer().m_129880_(pos.getDimensionKey());
        if (dimensionWorld != null) {
            return BlockEntityUtil.getWorldTileEntityUnchecked((Level)dimensionWorld, pos.getPos());
        }
        return null;
    }

    static BlockEntity getWorldTileEntityUnchecked(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return null;
        }
        return level.m_46745_(pos).m_5685_(pos, LevelChunk.EntityCreationType.IMMEDIATE);
    }

    public static void updateTile(Level level, BlockPos pos) {
        if (level == null || level.f_46443_ || !level.m_46749_(pos)) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        level.m_7260_(pos, state, state, 2);
        level.m_151543_(pos);
    }

    public static boolean hasCapabilityOnAnySide(BlockEntity blockEntity, Capability<?> capability) {
        for (Direction face : Direction.values()) {
            if (!blockEntity.getCapability(capability, face).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static ItemEntity getDroppedItemWithNbt(ItemStack itemStack, BlockEntity blockEntity) {
        CompoundTag CompoundTag2 = blockEntity.m_187482_();
        if (!CompoundTag2.m_128456_()) {
            itemStack.m_41700_("BlockEntityTag", (Tag)CompoundTag2);
        }
        ItemEntity itementity = new ItemEntity(blockEntity.m_58904_(), (double)blockEntity.m_58899_().m_123341_(), (double)blockEntity.m_58899_().m_123342_(), (double)blockEntity.m_58899_().m_123343_(), itemStack);
        itementity.m_32060_();
        return itementity;
    }

    public static void onBlockChangeDropWithNbt(Block block, BlockState state, Level level, BlockPos pos, BlockState newState) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity;
            if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) != null) {
                level.m_7967_((Entity)BlockEntityUtil.getDroppedItemWithNbt(new ItemStack((ItemLike)block), blockEntity));
            }
            level.m_46717_(pos, block);
        }
    }

    public static ItemStack getItemWithNbt(Block block, BlockGetter level, BlockPos pos) {
        ItemStack itemStack = new ItemStack((ItemLike)block);
        BlockEntity blockEntity = level.m_7702_(pos);
        CompoundTag CompoundTag2 = blockEntity.serializeNBT();
        if (!CompoundTag2.m_128456_()) {
            itemStack.m_41700_("BlockEntityTag", (Tag)CompoundTag2);
        }
        return itemStack;
    }
}

