/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.network.OccultismPackets;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public class StorageUtil {
    public static void clearOpenCraftingMatrix(ServerPlayer player, boolean sendStackUpdate) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof IStorageControllerContainer) {
            IStorageControllerContainer container = (IStorageControllerContainer)abstractContainerMenu;
            CraftingContainer craftMatrix = container.getCraftMatrix();
            IStorageController storageController = container.getStorageController();
            if (storageController == null) {
                return;
            }
            for (int i = 0; i < 9; ++i) {
                int remainingAfterInsert;
                int amountBeforeInsert;
                ItemStack stackInSlot = craftMatrix.m_8020_(i);
                if (stackInSlot.m_41619_() || (amountBeforeInsert = stackInSlot.m_41613_()) == (remainingAfterInsert = storageController.insertStack(stackInSlot.m_41777_(), false))) continue;
                if (remainingAfterInsert == 0) {
                    craftMatrix.m_6836_(i, ItemStack.f_41583_);
                    continue;
                }
                craftMatrix.m_6836_(i, ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)remainingAfterInsert));
            }
            if (sendStackUpdate) {
                OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
                ((AbstractContainerMenu)container).m_38946_();
            }
            container.updateCraftingSlots(true);
        }
    }

    public static void clearOpenOrderSlot(ServerPlayer player, boolean sendStackUpdate) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof IStorageControllerContainer) {
            int remainingAfterInsert;
            int amountBeforeInsert;
            IStorageControllerContainer container = (IStorageControllerContainer)abstractContainerMenu;
            SimpleContainer orderSlot = container.getOrderSlot();
            IStorageController storageController = container.getStorageController();
            if (storageController == null) {
                return;
            }
            ItemStack stackInSlot = orderSlot.m_8020_(0);
            if (!stackInSlot.m_41619_() && (amountBeforeInsert = stackInSlot.m_41613_()) != (remainingAfterInsert = storageController.insertStack(stackInSlot.m_41777_(), false))) {
                if (remainingAfterInsert == 0) {
                    orderSlot.m_6836_(0, ItemStack.f_41583_);
                } else {
                    orderSlot.m_6836_(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)remainingAfterInsert));
                }
            }
            if (sendStackUpdate) {
                OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
                ((AbstractContainerMenu)container).m_38946_();
            }
        }
    }

    public static ItemStack extractItem(IItemHandler itemHandler, Predicate<ItemStack> comparator, int amount, boolean simulate) {
        if (itemHandler == null || comparator == null) {
            return ItemStack.f_41583_;
        }
        int amountExtracted = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack extractedStack;
            ItemStack slot = itemHandler.getStackInSlot(i);
            if (!comparator.test(slot) || (extractedStack = itemHandler.extractItem(i, 1, simulate)).m_41619_()) continue;
            if (++amountExtracted == amount) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)slot, (int)amount);
            }
            --i;
        }
        return ItemStack.f_41583_;
    }

    public static int getFirstFilledSlot(IItemHandler handler) {
        return StorageUtil.getFirstFilledSlotAfter(handler, -1);
    }

    public static int getFirstFilledSlotAfter(IItemHandler handler, int slot) {
        for (int i = slot + 1; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstMatchingSlot(IItemHandler handler, IItemHandler filter, String tagFilter, boolean isBlacklist) {
        return StorageUtil.getFirstMatchingSlotAfter(handler, -1, filter, tagFilter, isBlacklist);
    }

    public static int getFirstMatchingSlotAfter(IItemHandler handler, int slot, IItemHandler filter, String tagFilter, boolean isBlacklist) {
        for (int i = slot + 1; i < handler.getSlots(); ++i) {
            boolean matches;
            if (handler.getStackInSlot(i).m_41619_()) continue;
            boolean bl = matches = StorageUtil.matchesFilter(handler.getStackInSlot(i), filter) || StorageUtil.matchesFilter(handler.getStackInSlot(i), tagFilter);
            if ((isBlacklist || !matches) && (!isBlacklist || matches)) continue;
            return i;
        }
        return -1;
    }

    public static boolean matchesFilter(ItemStack stack, IItemHandler filter) {
        for (int i = 0; i < filter.getSlots(); ++i) {
            ItemStack filtered = filter.getStackInSlot(i);
            boolean equals = filtered.m_41656_(stack);
            if (!equals) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesFilter(ItemStack stack, String tagFilter) {
        String[] filters;
        if (tagFilter.isEmpty()) {
            return false;
        }
        for (String filter : filters = tagFilter.split(";")) {
            if (filter.startsWith("item:")) {
                filter = filter.substring(5);
                if (!FilenameUtils.wildcardMatch((String)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString(), (String)filter, (IOCase)IOCase.INSENSITIVE)) continue;
                return true;
            }
            if (filter.startsWith("tag:")) {
                filter = filter.substring(4);
            }
            String finalFilter = filter;
            boolean equals = stack.m_204131_().anyMatch(tag -> FilenameUtils.wildcardMatch((String)tag.f_203868_().toString(), (String)finalFilter, (IOCase)IOCase.INSENSITIVE));
            if (!equals) continue;
            return true;
        }
        return false;
    }

    public static void dropInventoryItems(BlockEntity blockEntity) {
        blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> StorageUtil.dropInventoryItems(blockEntity.m_58904_(), blockEntity.m_58899_(), handler));
    }

    public static void dropInventoryItems(Level worldIn, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemHandler.getStackInSlot(i));
        }
    }

    public static int getFirstMatchingSlot(IItemHandler handler, TagKey<Item> tag) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.getStackInSlot(i).m_204117_(tag)) continue;
            return i;
        }
        return -1;
    }
}

