/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.roguelogix.phosphophyllite.config.ConfigFormat;
import net.roguelogix.phosphophyllite.config.ConfigRegistration;
import net.roguelogix.phosphophyllite.config.ConfigType;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.registry.RegisterConfig;
import net.roguelogix.phosphophyllite.robn.ROBN;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.ReflectionUtil;
import net.roguelogix.phosphophyllite.util.TriConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@NonnullDefault
public class ConfigManager {
    static final Logger LOGGER = LogManager.getLogger((String)"Phosphophyllite/Config");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("phosphophyllite", "phosphophyllite/configsync"), () -> "1", "1"::equals, "1"::equals);
    private static final Object2ObjectOpenHashMap<String, ConfigRegistration> clientConfigs = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<String, ConfigRegistration> commonConfigs = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<String, ConfigRegistration> serverConfigs = new Object2ObjectOpenHashMap();
    private static boolean connectedToServer = false;
    @Nullable
    private static MinecraftServer server;
    private static final ObjectArrayList<ServerPlayer> players;

    public static void registerConfig(Object rootConfigObject, RegisterConfig annotation) {
        ConfigManager.registerConfig(rootConfigObject, ModLoadingContext.get().getActiveNamespace(), annotation);
    }

    public static void registerConfig(Object rootConfigObject, String modName, RegisterConfig annotation) {
        TriConsumer<Map, Method, ConfigType[]> createCallback = (callbacks, method, applicableTypes) -> {
            if (((ConfigType[])applicableTypes).length == 0) {
                applicableTypes = ConfigType.values();
            }
            Runnable runnable = ReflectionUtil.createRunnableForFunction(method);
            for (ConfigType type : applicableTypes) {
                List list = (List)callbacks.get((Object)type);
                if (list == null) {
                    list = new ObjectArrayList();
                    callbacks.put(type, list);
                }
                list.add(runnable);
            }
        };
        Object2ObjectOpenHashMap registrationCallbacks = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap preLoadCallbacks = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap postLoadCallbacks = new Object2ObjectOpenHashMap();
        for (Method method2 : rootConfigObject.getClass().getDeclaredMethods()) {
            Annotation callbackAnnotation;
            if (method2.isAnnotationPresent(RegisterConfig.Registration.class)) {
                callbackAnnotation = method2.getAnnotation(RegisterConfig.Registration.class);
                createCallback.accept((Map)registrationCallbacks, method2, callbackAnnotation.type());
            }
            if (method2.isAnnotationPresent(RegisterConfig.PreLoad.class)) {
                callbackAnnotation = method2.getAnnotation(RegisterConfig.PreLoad.class);
                createCallback.accept((Map)preLoadCallbacks, method2, callbackAnnotation.type());
            }
            if (!method2.isAnnotationPresent(RegisterConfig.PostLoad.class)) continue;
            callbackAnnotation = method2.getAnnotation(RegisterConfig.PostLoad.class);
            createCallback.accept((Map)postLoadCallbacks, method2, callbackAnnotation.type());
        }
        ConfigManager.registerConfig(rootConfigObject, modName, annotation.name(), annotation.folder(), annotation.comment(), annotation.format(), annotation.type(), annotation.rootLevelType(), annotation.rootLevelReloadable(), (Map<ConfigType, List<Runnable>>)registrationCallbacks, (Map<ConfigType, List<Runnable>>)preLoadCallbacks, (Map<ConfigType, List<Runnable>>)postLoadCallbacks);
    }

    public static void registerConfig(Object rootConfigObject, String modName, String name, String folder, String comment, ConfigFormat format, ConfigType[] configTypes, ConfigType rootLevelDefaultType, boolean rootLevelReloadableDefault, Map<ConfigType, List<Runnable>> registrationCallbacks, Map<ConfigType, List<Runnable>> preLoadCallbacks, Map<ConfigType, List<Runnable>> postLoadCallbacks) {
        if (configTypes.length == 1) {
            rootLevelDefaultType = rootLevelDefaultType.from(configTypes[0]);
        } else if (rootLevelDefaultType == ConfigType.NULL) {
            throw new IllegalArgumentException("Must specify root level default type when registering multiple config types");
        }
        if (name.isEmpty()) {
            name = modName;
        }
        for (ConfigType configType : Arrays.stream(configTypes).collect(Collectors.toSet())) {
            Object2ObjectOpenHashMap<String, ConfigRegistration> configs;
            if (!configType.appliesToPhysicalSide) continue;
            switch (configType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NULL: {
                    Object2ObjectOpenHashMap<String, ConfigRegistration> object2ObjectOpenHashMap = null;
                    break;
                }
                case CLIENT: {
                    Object2ObjectOpenHashMap<String, ConfigRegistration> object2ObjectOpenHashMap = clientConfigs;
                    break;
                }
                case COMMON: {
                    Object2ObjectOpenHashMap<String, ConfigRegistration> object2ObjectOpenHashMap = commonConfigs;
                    break;
                }
                case SERVER: {
                    Object2ObjectOpenHashMap<String, ConfigRegistration> object2ObjectOpenHashMap = configs = serverConfigs;
                }
            }
            assert (configs != null);
            ConfigRegistration registration = new ConfigRegistration(rootConfigObject, modName, name, folder, comment, format, configType, rootLevelDefaultType, rootLevelReloadableDefault, preLoadCallbacks.getOrDefault((Object)configType, (List<Runnable>)new ObjectArrayList()), postLoadCallbacks.getOrDefault((Object)configType, (List<Runnable>)new ObjectArrayList()));
            if (registration.isEmpty()) continue;
            configs.put((Object)name, (Object)registration);
            List<Runnable> callbacks = registrationCallbacks.get((Object)configType);
            if (callbacks != null) {
                callbacks.forEach(Runnable::run);
            }
            registration.loadLocalConfigFile(false);
        }
    }

    public static void reloadAllConfigs() {
        for (ConfigRegistration value : clientConfigs.values()) {
            value.loadLocalConfigFile(true);
        }
        if (FMLEnvironment.dist.isDedicatedServer() || server == null || !server.m_6982_()) {
            for (ConfigRegistration value : commonConfigs.values()) {
                value.loadLocalConfigFile(true);
            }
            for (ConfigRegistration value : serverConfigs.values()) {
                value.loadLocalConfigFile(true);
            }
            for (ServerPlayer player : players) {
                ConfigManager.sendConfigToPlayer(player, false);
            }
        }
    }

    public static List<ConfigRegistration> getAllConfigsForMod(String modName) {
        return Stream.concat(clientConfigs.values().stream(), Stream.concat(commonConfigs.values().stream(), serverConfigs.values().stream())).filter(configRegistration -> configRegistration.modName.equals(modName)).collect(Collectors.toList());
    }

    @OnModLoad
    private static void onModLoad() {
        NETWORK_CHANNEL.registerMessage(1, ByteArrayPacketMessage.class, ByteArrayPacketMessage::encodePacket, ByteArrayPacketMessage::decodePacket, ConfigManager::packetHandler);
        MinecraftForge.EVENT_BUS.addListener(ConfigManager::onPlayerLogin);
        MinecraftForge.EVENT_BUS.addListener(ConfigManager::onPlayerLogout);
        MinecraftForge.EVENT_BUS.addListener(ConfigManager::onServerAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(ConfigManager::onServerStopped);
        if (FMLEnvironment.dist.isClient()) {
            MinecraftForge.EVENT_BUS.addListener(ConfigManager::onLoggingIn);
            MinecraftForge.EVENT_BUS.addListener(ConfigManager::onLoggingOut);
        }
    }

    private static void onServerAboutToStart(ServerAboutToStartEvent event) {
        server = event.getServer();
    }

    private static void onServerStopped(ServerStoppedEvent event) {
        server = null;
        players.clear();
    }

    private static void onLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        connectedToServer = true;
    }

    private static void onLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        connectedToServer = false;
        commonConfigs.values().forEach(ConfigRegistration::unloadRemoteConfig);
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        MinecraftServer server = e.getEntity().m_20194_();
        assert (server != null);
        if (!server.m_6982_()) {
            UUID serverUUID = e.getEntity().m_20148_();
            String localUUID = Minecraft.m_91087_().m_91094_().m_92545_();
            if (serverUUID.toString().equals(localUUID)) {
                for (ConfigRegistration value : commonConfigs.values()) {
                    value.unloadRemoteConfig();
                }
                return;
            }
        }
        ServerPlayer player = (ServerPlayer)e.getEntity();
        players.add((Object)player);
        ConfigManager.sendConfigToPlayer(player, true);
    }

    private static void sendConfigToPlayer(ServerPlayer player, boolean initialLogin) {
        Object2ObjectOpenHashMap configs = new Object2ObjectOpenHashMap();
        for (ConfigRegistration modConfig : commonConfigs.values()) {
            Element configTree = modConfig.rootConfigSpecNode.generateSyncElement();
            ArrayList<Byte> configROBN = net.roguelogix.phosphophyllite.parsers.ROBN.parseElement(configTree);
            if (configROBN == null) continue;
            configs.put((Object)modConfig.baseFile.toString(), configROBN);
        }
        ArrayList<Byte> robn = ROBN.toROBN(new Pair((Object)initialLogin, (Object)configs));
        byte[] bytes = new byte[robn.size()];
        for (int i = 0; i < robn.size(); ++i) {
            bytes[i] = robn.get(i);
        }
        NETWORK_CHANNEL.sendTo((Object)new ByteArrayPacketMessage(bytes), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        ServerPlayer player = (ServerPlayer)e.getEntity();
        players.remove((Object)player);
    }

    private static void packetHandler(@Nonnull ByteArrayPacketMessage packet, @Nonnull Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().setPacketHandled(true);
            return;
        }
        ctx.get().enqueueWork(() -> {
            try {
                ArrayList<Byte> buf = new ArrayList<Byte>();
                for (byte aByte : packet.bytes) {
                    buf.add(aByte);
                }
                Pair pair = (Pair)ROBN.fromROBN(buf);
                boolean initialLogin = (Boolean)pair.getFirst();
                Map configs = (Map)pair.getSecond();
                for (Map.Entry entry : configs.entrySet()) {
                    String configName = (String)entry.getKey();
                    ConfigRegistration config = (ConfigRegistration)commonConfigs.get((Object)configName);
                    if (config == null) {
                        return;
                    }
                    try {
                        Element elementTree = net.roguelogix.phosphophyllite.parsers.ROBN.parseROBN((ArrayList)entry.getValue());
                        config.loadRemoteConfig(elementTree, !initialLogin);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
        ctx.get().setPacketHandled(true);
    }

    static {
        players = new ObjectArrayList();
    }

    private static class ByteArrayPacketMessage {
        public byte[] bytes;

        public ByteArrayPacketMessage(@Nonnull byte[] readByteArray) {
            this.bytes = readByteArray;
        }

        private static void encodePacket(@Nonnull ByteArrayPacketMessage packet, @Nonnull FriendlyByteBuf buf) {
            buf.writeBytes(packet.bytes);
        }

        private static ByteArrayPacketMessage decodePacket(@Nonnull FriendlyByteBuf buf) {
            byte[] byteBuf = new byte[buf.readableBytes()];
            buf.readBytes(byteBuf);
            return new ByteArrayPacketMessage(byteBuf);
        }
    }
}

