/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.debug;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nullable;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public class DebugInfo {
    private final String name;
    private final ObjectArrayList<Object> values = new ObjectArrayList();

    public DebugInfo(String name) {
        this.name = name;
    }

    public DebugInfo(String name, DebugInfo toCopy) {
        this.name = name;
        this.values.addAll(toCopy.values);
    }

    public String name() {
        return this.name;
    }

    public DebugInfo add(@Nullable DebugInfo subInfo) {
        if (subInfo == null) {
            return this;
        }
        this.values.add((Object)subInfo);
        return this;
    }

    public DebugInfo add(@Nullable String str) {
        if (str == null) {
            return this;
        }
        this.values.add((Object)str);
        return this;
    }

    private ObjectArrayList<String> valuesAsStrings() {
        ObjectArrayList strings = new ObjectArrayList(this.values.size());
        for (Object value : this.values) {
            strings.add((Object)value.toString());
        }
        return strings;
    }

    public String toString() {
        ObjectArrayList<String> valueStrings = this.valuesAsStrings();
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append(":\n");
        for (int j = 0; j < valueStrings.size(); ++j) {
            String value = (String)valueStrings.get(j);
            boolean hasNext = j != valueStrings.size() - 1;
            String[] valueLines = value.split("\n");
            for (int i = 0; i < valueLines.length; ++i) {
                if (i == 0) {
                    builder.append(hasNext ? "\u251c\u2500" : "\u2514\u2500");
                } else {
                    builder.append(hasNext ? "\u2502 " : "  ");
                }
                builder.append(valueLines[i]);
                builder.append('\n');
            }
        }
        return builder.toString();
    }
}

