/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.fluids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.roguelogix.phosphophyllite.fluids.PhosphophylliteFluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IPhosphophylliteFluidHandler
extends IFluidHandler {
    public static final PhosphophylliteFluidStack stack = new PhosphophylliteFluidStack();

    default public LazyOptional<IFluidHandler> fluidHandlerCapability() {
        return LazyOptional.of(() -> this);
    }

    default public int getTanks() {
        return this.tankCount();
    }

    @Nonnull
    default public FluidStack getFluidInTank(int tank) {
        stack.setFluid(this.fluidTypeInTank(tank));
        if (stack.getRawFluid() == Fluids.f_76191_) {
            return FluidStack.EMPTY;
        }
        stack.setAmount(this.fluidAmountInTank(tank));
        stack.setTag(this.fluidTagInTank(tank));
        return stack;
    }

    default public int getTankCapacity(int tank) {
        return (int)Math.min(Integer.MAX_VALUE, this.tankCapacity(tank));
    }

    default public boolean isFluidValid(int tank, FluidStack resource) {
        return this.fluidValidForTank(tank, resource.getRawFluid());
    }

    default public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return (int)this.fill(resource.getRawFluid(), resource.getTag(), resource.getAmount(), action.simulate());
    }

    @Nonnull
    default public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int drainedAmount = (int)this.drain(resource.getRawFluid(), resource.getTag(), resource.getAmount(), action.simulate());
        if (drainedAmount == 0) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(resource, drainedAmount);
    }

    @Nonnull
    default public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drainedAmount = 0;
        Fluid fluid = null;
        for (int i = 0; i < this.tankCount() && (drainedAmount = (int)this.drain(fluid = this.fluidTypeInTank(i), this.fluidTagInTank(i), maxDrain, action.simulate())) == 0; ++i) {
        }
        if (drainedAmount == 0) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(fluid, drainedAmount);
    }

    public int tankCount();

    public long tankCapacity(int var1);

    public Fluid fluidTypeInTank(int var1);

    @Nullable
    public CompoundTag fluidTagInTank(int var1);

    public long fluidAmountInTank(int var1);

    public boolean fluidValidForTank(int var1, Fluid var2);

    public long fill(Fluid var1, @Nullable CompoundTag var2, long var3, boolean var5);

    public long drain(Fluid var1, @Nullable CompoundTag var2, long var3, boolean var5);
}

