/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock.rectangular;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.multiblock.IMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.ValidationError;
import net.roguelogix.phosphophyllite.multiblock.Validator;
import net.roguelogix.phosphophyllite.multiblock.rectangular.IRectangularMultiblockBlock;
import net.roguelogix.phosphophyllite.multiblock.rectangular.InvalidBlock;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.util.Util;

@Deprecated(forRemoval=true)
public class RectangularMultiblockController<TileType extends BlockEntity, ControllerType extends RectangularMultiblockController<TileType, ControllerType>>
extends MultiblockController<TileType, ControllerType> {
    final Validator<Block> blockTypeValidator;
    protected boolean orientationAgnostic = true;
    protected boolean xzAgnostic = true;
    protected final Vector3i minSize = new Vector3i();
    protected final Vector3i maxSize = new Vector3i();
    protected Validator<Block> cornerValidator = null;
    protected Validator<Block> frameValidator = null;
    protected Validator<Block> exteriorValidator = null;
    protected Validator<Block> interiorValidator = null;
    protected Validator<Block> genericValidator = null;
    protected Consumer<Block> blockValidatedCallback = null;
    protected Runnable validationStartedCallback = null;
    private int foundMultiblockBlocks;
    private final Validator<ControllerType> mainValidator = controller -> {
        int minX = controller.minCoord().x();
        int minY = controller.minCoord().y();
        int minZ = controller.minCoord().z();
        int maxX = controller.maxCoord().x();
        int maxY = controller.maxCoord().y();
        int maxZ = controller.maxCoord().z();
        Vector3i[] allowedOrientations = new Vector3i[controller.orientationAgnostic ? 6 : (controller.xzAgnostic ? 2 : 1)];
        if (controller.orientationAgnostic) {
            allowedOrientations[0] = new Vector3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
            allowedOrientations[1] = new Vector3i(maxX - minX + 1, maxZ - minZ + 1, maxY - minY + 1);
            allowedOrientations[2] = new Vector3i(maxY - minY + 1, maxX - minX + 1, maxZ - minZ + 1);
            allowedOrientations[3] = new Vector3i(maxY - minY + 1, maxZ - minZ + 1, maxX - minX + 1);
            allowedOrientations[4] = new Vector3i(maxZ - minZ + 1, maxX - minX + 1, maxY - minY + 1);
            allowedOrientations[5] = new Vector3i(maxZ - minZ + 1, maxY - minY + 1, maxX - minX + 1);
        } else if (controller.xzAgnostic) {
            allowedOrientations[0] = new Vector3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
            allowedOrientations[1] = new Vector3i(maxZ - minZ + 1, maxY - minY + 1, maxX - minX + 1);
        } else {
            allowedOrientations[0] = new Vector3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
        }
        Vector3i dimensions = null;
        for (Vector3i allowedOrientation : allowedOrientations) {
            if ((controller.minSize.x | controller.minSize.y | controller.minSize.z) >= 0 && (allowedOrientation.x < controller.minSize.x || allowedOrientation.y < controller.minSize.y || allowedOrientation.z < controller.minSize.z) || (controller.maxSize.x | controller.maxSize.y | controller.maxSize.z) >= 0 && (allowedOrientation.x > controller.maxSize.x || allowedOrientation.y > controller.maxSize.y || allowedOrientation.z > controller.maxSize.z)) continue;
            dimensions = allowedOrientation;
            break;
        }
        if (dimensions == null) {
            throw new ValidationError((Component)Component.m_237110_((String)"multiblock.error.phosphophyllite.dimensions", (Object[])new Object[]{allowedOrientations[0].x, allowedOrientations[0].y, allowedOrientations[0].z, controller.minSize.x, controller.minSize.y, controller.minSize.z, controller.maxSize.x, controller.maxSize.y, controller.maxSize.z}));
        }
        if (this.validationStartedCallback != null) {
            this.validationStartedCallback.run();
        }
        this.foundMultiblockBlocks = 0;
        Util.chunkCachedBlockStateIteration(controller.minCoord(), controller.maxCoord(), controller.world, (blockState, pos) -> {
            Block block = blockState.m_60734_();
            int extremes = 0;
            if (pos.x == minX || pos.x == maxX) {
                ++extremes;
            }
            if (pos.y == minY || pos.y == maxY) {
                ++extremes;
            }
            if (pos.z == minZ || pos.z == maxZ) {
                ++extremes;
            }
            switch (extremes) {
                case 3: {
                    if (block instanceof IRectangularMultiblockBlock && controller.blockTypeValidator.validate(block)) {
                        ++this.foundMultiblockBlocks;
                        if (((IRectangularMultiblockBlock)block).isGoodForCorner()) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "corner");
                    }
                    if (controller.cornerValidator != null) {
                        if (controller.cornerValidator.validate(block)) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "corner");
                    }
                }
                case 2: {
                    if (block instanceof IRectangularMultiblockBlock && controller.blockTypeValidator.validate(block)) {
                        ++this.foundMultiblockBlocks;
                        if (((IRectangularMultiblockBlock)block).isGoodForFrame()) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "frame");
                    }
                    if (controller.frameValidator != null) {
                        if (controller.frameValidator.validate(block)) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "frame");
                    }
                }
                case 1: {
                    if (block instanceof IRectangularMultiblockBlock && controller.blockTypeValidator.validate(block)) {
                        ++this.foundMultiblockBlocks;
                        if (((IRectangularMultiblockBlock)block).isGoodForExterior()) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "exterior");
                    }
                    if (controller.exteriorValidator != null) {
                        if (controller.exteriorValidator.validate(block)) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "exterior");
                    }
                }
                default: {
                    if (extremes == 0) {
                        if (block instanceof IRectangularMultiblockBlock && controller.blockTypeValidator.validate(block)) {
                            ++this.foundMultiblockBlocks;
                            if (((IRectangularMultiblockBlock)block).isGoodForInterior()) break;
                            throw new InvalidBlock(block, (Vector3i)pos, "interior");
                        }
                        if (controller.interiorValidator != null) {
                            if (controller.interiorValidator.validate(block)) break;
                            throw new InvalidBlock(block, (Vector3i)pos, "interior");
                        }
                    }
                    if (controller.genericValidator != null) {
                        if (controller.genericValidator.validate(block)) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "generic");
                    }
                    throw new InvalidBlock(block, (Vector3i)pos, "generic");
                }
            }
            if (this.blockValidatedCallback != null) {
                this.blockValidatedCallback.accept(block);
            }
        });
        if (this.foundMultiblockBlocks != controller.blocks.size()) {
            throw new ValidationError((Component)Component.m_237110_((String)"multiblock.error.phosphophyllite.mismatched_block_count", (Object[])new Object[]{this.foundMultiblockBlocks, controller.blocks.size()}));
        }
        return true;
    };

    public RectangularMultiblockController(@Nonnull Level world, @Nonnull Validator<IMultiblockTile<?, ?>> tileTypeValidator, @Nonnull Validator<Block> blockTypeValidator) {
        super(world, tileTypeValidator, true);
        this.blockTypeValidator = blockTypeValidator;
    }

    @Override
    protected final void setAssemblyValidator(@Nullable Validator<ControllerType> validator) {
        if (validator == null) {
            super.setAssemblyValidator(this.mainValidator);
            return;
        }
        super.setAssemblyValidator(Validator.and(this.mainValidator, validator));
    }
}

