/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.ChargingStationUpgradeManagerMenu;
import me.desht.pneumaticcraft.common.inventory.JackhammerSetupMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.DrillBitItem;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class JackHammerItem
extends PressurizableItem
implements IChargeableContainerProvider,
ColorHandlers.ITintableItem,
IShiftScrollable {
    private static final float[] SPEED_MULT = new float[]{1.0f, 2.0f, 2.4142137f, 2.732051f, 3.0f, 3.236068f, 3.4494898f, 3.6457512f, 3.828427f, 4.0f, 4.1622777f};
    private static final String NBT_DIG_MODE = "DigMode";
    private static long lastModeSwitchTime;

    public JackHammerItem() {
        super(ModItems.toolProps(), 120000, 12000);
    }

    public static long getLastModeSwitchTime() {
        return lastModeSwitchTime;
    }

    public static DrillBitHandler getDrillBitHandler(ItemStack stack) {
        if (stack.m_41720_() instanceof JackHammerItem) {
            return new DrillBitHandler(stack);
        }
        return null;
    }

    public static EnchantmentHandler getEnchantmentHandler(ItemStack stack) {
        if (stack.m_41720_() instanceof JackHammerItem) {
            return new EnchantmentHandler(stack);
        }
        return null;
    }

    public DrillBitItem.DrillBitType getDrillBit(ItemStack stack) {
        DrillBitItem.DrillBitType drillBitType;
        DrillBitHandler handler = new DrillBitHandler(stack);
        Item item = handler.getStackInSlot(0).m_41720_();
        if (item instanceof DrillBitItem) {
            DrillBitItem bit = (DrillBitItem)item;
            drillBitType = bit.getType();
        } else {
            drillBitType = DrillBitItem.DrillBitType.NONE;
        }
        return drillBitType;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return TierSortingRegistry.isCorrectTierForDrops((Tier)this.getDrillBit(stack).getTier(), (BlockState)state);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        DrillBitItem.DrillBitType bitType = this.getDrillBit(stack);
        int speed = bitType == DrillBitItem.DrillBitType.NONE ? 0 : UpgradableItemUtils.getUpgradeCount(stack, (PNCUpgrade)ModUpgrades.SPEED.get());
        return (float)this.getAir(stack) > 0.0f ? (float)bitType.getBaseEfficiency() * SPEED_MULT[speed] : 1.0f;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, final InteractionHand handIn) {
        final ItemStack stack = playerIn.m_21120_(handIn);
        if (!playerIn.m_6047_() || stack.m_41613_() != 1) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)playerIn;
            NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return stack.m_41786_();
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                    return new JackhammerSetupMenu(windowId, inv, handIn);
                }
            }, buf -> AbstractPneumaticCraftMenu.putHand(buf, handIn));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return this.getDrillBit(stack) != DrillBitItem.DrillBitType.NONE && (float)this.getAir(stack) > 0.0f;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        MutableBoolean didWork = new MutableBoolean(false);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!player.m_6144_()) {
                Level level = serverPlayer.m_20193_();
                HitResult hitResult = RayTraceUtils.getEntityLookedObject((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
                if (hitResult instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                    itemstack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(airHandler -> {
                        float usage;
                        float air;
                        DigMode digMode = JackHammerItem.getDigMode(itemstack);
                        List<Integer> upgrades = UpgradableItemUtils.getUpgradeList(itemstack, (PNCUpgrade)ModUpgrades.SPEED.get(), (PNCUpgrade)ModUpgrades.MAGNET.get());
                        int speed = upgrades.get(0);
                        boolean magnet = upgrades.get(1) > 0 && digMode.isVeinMining();
                        DrillBitItem.DrillBitType bitType = this.getDrillBit(itemstack);
                        if (TierSortingRegistry.getTiersLowerThan((Tier)digMode.getBitType().getTier()).contains(bitType.getTier())) {
                            digMode = DigMode.MODE_1X1;
                        }
                        Set<BlockPos> brokenPos = JackHammerItem.getBreakPositions(level, pos, blockHitResult.m_82434_(), player.m_6350_(), digMode);
                        brokenPos.remove(pos);
                        float air0 = air = (float)airHandler.getAir();
                        float f = usage = player.m_7500_() ? 0.0f : 50.0f * SPEED_MULT[speed];
                        if (magnet) {
                            usage *= 1.1f;
                        }
                        if (air >= usage) {
                            didWork.setTrue();
                            air -= usage;
                            for (BlockPos pos1 : brokenPos) {
                                int exp;
                                if (air < usage) break;
                                BlockState state1 = level.m_8055_(pos1);
                                if (state1.m_60800_((BlockGetter)level, pos1) < 0.0f || (exp = ForgeHooks.onBlockBreakEvent((Level)serverPlayer.f_19853_, (GameType)serverPlayer.f_8941_.m_9290_(), (ServerPlayer)serverPlayer, (BlockPos)pos1)) == -1 || level.m_7702_(pos1) != null) continue;
                                Block block = state1.m_60734_();
                                boolean removed = state1.onDestroyedByPlayer(level, pos1, player, true, level.m_6425_(pos1));
                                if (!removed) continue;
                                block.m_6786_((LevelAccessor)level, pos1, state1);
                                if (magnet) {
                                    JackHammerItem.magnetHarvest(block, level, player, pos, pos1, state1, itemstack);
                                } else {
                                    block.m_6240_(level, player, pos1, state1, null, itemstack);
                                }
                                if (exp > 0 && level instanceof ServerLevel) {
                                    block.m_49805_((ServerLevel)level, magnet ? pos : pos1, exp);
                                }
                                air -= usage;
                                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                            }
                            if (air != air0 && !player.m_7500_()) {
                                airHandler.addAir((int)(air - air0));
                            }
                        }
                    });
                }
            }
        }
        return !didWork.booleanValue();
    }

    private static void magnetHarvest(Block block, Level level, Player player, BlockPos pos0, BlockPos pos, BlockState state, ItemStack stack) {
        player.m_36246_(Stats.f_12949_.m_12902_((Object)block));
        player.m_36399_(0.005f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)player, (ItemStack)stack).forEach(stackToSpawn -> Block.m_49840_((Level)level, (BlockPos)pos0, (ItemStack)stackToSpawn));
            state.m_222967_(serverLevel, pos, stack, true);
        }
    }

    public static Set<BlockPos> getBreakPositions(Level world, BlockPos pos, Direction dir, Direction playerHoriz, DigMode digMode) {
        if (digMode.isVeinMining()) {
            return new HashSet<BlockPos>(JackHammerItem.getVeinPositions(world, pos, digMode));
        }
        HashSet<BlockPos> res = new HashSet<BlockPos>();
        if (digMode.atLeast(DigMode.MODE_1X2)) {
            res.add(dir.m_122434_() == Direction.Axis.Y ? pos.m_121945_(playerHoriz) : pos.m_7495_());
        }
        if (digMode.atLeast(DigMode.MODE_1X3)) {
            res.add(dir.m_122434_() == Direction.Axis.Y ? pos.m_121945_(playerHoriz.m_122424_()) : pos.m_7494_());
        }
        if (digMode.atLeast(DigMode.MODE_3X3_CROSS)) {
            switch (dir.m_122434_()) {
                case X: {
                    res.add(pos.m_122012_());
                    res.add(pos.m_122019_());
                    res.add(pos.m_7494_());
                    res.add(pos.m_7495_());
                    break;
                }
                case Y: {
                    res.add(pos.m_122012_());
                    res.add(pos.m_122019_());
                    res.add(pos.m_122024_());
                    res.add(pos.m_122029_());
                    break;
                }
                case Z: {
                    res.add(pos.m_7494_());
                    res.add(pos.m_7495_());
                    res.add(pos.m_122024_());
                    res.add(pos.m_122029_());
                }
            }
        }
        if (digMode.atLeast(DigMode.MODE_3X3_FULL)) {
            switch (dir.m_122434_()) {
                case X: {
                    res.add(pos.m_7494_().m_122012_());
                    res.add(pos.m_7494_().m_122019_());
                    res.add(pos.m_7495_().m_122012_());
                    res.add(pos.m_7495_().m_122019_());
                    break;
                }
                case Y: {
                    res.add(pos.m_122012_().m_122029_());
                    res.add(pos.m_122012_().m_122024_());
                    res.add(pos.m_122019_().m_122029_());
                    res.add(pos.m_122019_().m_122024_());
                    break;
                }
                case Z: {
                    res.add(pos.m_7494_().m_122029_());
                    res.add(pos.m_7494_().m_122024_());
                    res.add(pos.m_7495_().m_122029_());
                    res.add(pos.m_7495_().m_122024_());
                }
            }
        }
        return res;
    }

    private static List<BlockPos> getVeinPositions(Level world, BlockPos startPos, DigMode mode) {
        BlockState state = world.m_8055_(startPos);
        if (!mode.okToVeinMine(state)) {
            return Collections.emptyList();
        }
        int maxRange = (Integer)ConfigHelper.common().jackhammer.maxVeinMinerRange.get();
        int maxRangeSq = maxRange * maxRange;
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        found.add(startPos);
        ObjectOpenHashSet checked = new ObjectOpenHashSet();
        Block startBlock = state.m_60734_();
        int maxBlocks = mode.getBlocksDug();
        for (int i = 0; i < found.size(); ++i) {
            BlockPos blockPos = (BlockPos)found.get(i);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-1, -1, -1), (BlockPos)blockPos.m_7918_(1, 1, 1))) {
                if (checked.contains(pos) || mode == DigMode.MODE_VEIN_PLUS && startPos.m_123331_((Vec3i)pos) > (double)maxRangeSq || !world.m_46749_(pos) || startBlock != world.m_8055_(pos).m_60734_()) continue;
                BlockPos pos1 = pos.m_7949_();
                found.add(pos1);
                checked.add(pos1);
                if (found.size() <= maxBlocks) continue;
                return found;
            }
        }
        return found;
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, (MenuType<? extends ChargingStationUpgradeManagerMenu>)((MenuType)ModMenuTypes.CHARGING_JACKHAMMER.get()));
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return this.getDrillBit(stack).getTint();
        }
        return -1;
    }

    public static DigMode getDigMode(ItemStack stack) {
        if (stack.m_41720_() instanceof JackHammerItem && stack.m_41782_()) {
            try {
                return Objects.requireNonNull(stack.m_41783_()).m_128441_(NBT_DIG_MODE) ? DigMode.valueOf(stack.m_41783_().m_128461_(NBT_DIG_MODE)) : DigMode.MODE_1X1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return DigMode.MODE_1X1;
    }

    public static void setDigMode(ItemStack stack, DigMode mode) {
        stack.m_41784_().m_128359_(NBT_DIG_MODE, mode.toString());
    }

    public static DigMode cycleDigMode(ItemStack stack, boolean forward) {
        if (stack.m_41720_() instanceof JackHammerItem) {
            DigMode currentMode;
            DrillBitItem.DrillBitType ourBit = ((JackHammerItem)stack.m_41720_()).getDrillBit(stack);
            DigMode newMode = currentMode = JackHammerItem.getDigMode(stack);
            if (forward) {
                newMode = currentMode == DigMode.MODE_VEIN_PLUS ? DigMode.MODE_1X1 : ((newMode = DigMode.values()[currentMode.ordinal() + 1]).getBitType().getBitQuality() <= ourBit.getBitQuality() ? newMode : DigMode.MODE_1X1);
            } else if (currentMode == DigMode.MODE_1X1) {
                for (int i = DigMode.values().length - 1; i >= 0; --i) {
                    if (DigMode.values()[i].getBitType().getBitQuality() > ourBit.getBitQuality()) continue;
                    newMode = DigMode.values()[i];
                    break;
                }
            } else {
                newMode = DigMode.values()[currentMode.ordinal() - 1];
            }
            JackHammerItem.setDigMode(stack, newMode);
            return newMode;
        }
        return null;
    }

    @Override
    public void onShiftScrolled(Player player, boolean forward, InteractionHand hand) {
        if (!player.f_19853_.f_46443_) {
            DigMode newMode = JackHammerItem.cycleDigMode(player.m_21120_(hand), forward);
            if (newMode != null) {
                player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.jackhammer.mode", new Object[0]).m_7220_((Component)PneumaticCraftUtils.xlate(newMode.getTranslationKey(), new Object[0]).m_130940_(ChatFormatting.YELLOW)), true);
            }
        } else {
            lastModeSwitchTime = player.f_19853_.m_46467_();
        }
    }

    public static class DrillBitHandler
    extends BaseItemStackHandler {
        private static final String NBT_DRILL_BIT = "DrillBit";
        private final ItemStack jackhammerStack;

        public DrillBitHandler(ItemStack jackhammerStack) {
            super(1);
            this.jackhammerStack = jackhammerStack;
            if (jackhammerStack.m_41782_() && Objects.requireNonNull(jackhammerStack.m_41783_()).m_128425_(NBT_DRILL_BIT, 8)) {
                String name = jackhammerStack.m_41783_().m_128461_(NBT_DRILL_BIT);
                try {
                    DrillBitItem.DrillBitType type = DrillBitItem.DrillBitType.valueOf(name);
                    this.setStackInSlot(0, type.asItemStack());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || itemStack.m_41720_() instanceof DrillBitItem;
        }

        public void save() {
            ItemStack bitStack = this.getStackInSlot(0);
            Item item = bitStack.m_41720_();
            if (item instanceof DrillBitItem) {
                DrillBitItem bit = (DrillBitItem)item;
                NBTUtils.setString(this.jackhammerStack, NBT_DRILL_BIT, bit.getType().toString());
            } else {
                NBTUtils.setString(this.jackhammerStack, NBT_DRILL_BIT, DrillBitItem.DrillBitType.NONE.toString());
            }
        }
    }

    public static class EnchantmentHandler
    extends BaseItemStackHandler {
        private final ItemStack jackhammerStack;

        public EnchantmentHandler(ItemStack jackhammerStack) {
            super(1);
            this.jackhammerStack = jackhammerStack;
            Map ench = EnchantmentHelper.m_44831_((ItemStack)jackhammerStack);
            for (Map.Entry map : ench.entrySet()) {
                if (map.getKey() != Enchantments.f_44985_ && map.getKey() != Enchantments.f_44987_) continue;
                ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
                EnchantmentHelper.m_44865_(Collections.singletonMap((Enchantment)map.getKey(), (Integer)map.getValue()), (ItemStack)book);
                this.setStackInSlot(0, book);
                break;
            }
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.m_41619_() || EnchantmentHandler.validateBook(stack);
        }

        public void save() {
            ItemStack bookStack = this.getStackInSlot(0);
            Map currentEnchants = EnchantmentHelper.m_44831_((ItemStack)this.jackhammerStack);
            currentEnchants.remove(Enchantments.f_44985_);
            currentEnchants.remove(Enchantments.f_44987_);
            if (EnchantmentHandler.validateBook(bookStack)) {
                currentEnchants.putAll(EnchantmentHelper.m_44831_((ItemStack)bookStack));
            }
            EnchantmentHelper.m_44865_((Map)currentEnchants, (ItemStack)this.jackhammerStack);
        }

        public static boolean validateBook(ItemStack bookStack) {
            if (bookStack.m_41720_() == Items.f_42690_) {
                Map ench = EnchantmentHelper.m_44831_((ItemStack)bookStack);
                if (ench.size() != 1) {
                    return false;
                }
                return ench.containsKey(Enchantments.f_44987_) || ench.containsKey(Enchantments.f_44985_);
            }
            return false;
        }
    }

    public static enum DigMode implements ITranslatableEnum
    {
        MODE_1X1("1x1", 1, DrillBitItem.DrillBitType.IRON),
        MODE_1X2("1x2", 2, DrillBitItem.DrillBitType.COMPRESSED_IRON),
        MODE_1X3("1x3", 3, DrillBitItem.DrillBitType.COMPRESSED_IRON),
        MODE_3X3_CROSS("3x3_cross", 5, DrillBitItem.DrillBitType.DIAMOND),
        MODE_VEIN("vein", 128, DrillBitItem.DrillBitType.DIAMOND),
        MODE_3X3_FULL("3x3_full", 9, DrillBitItem.DrillBitType.DIAMOND),
        MODE_VEIN_PLUS("vein_plus", 128, DrillBitItem.DrillBitType.NETHERITE);

        private final String name;
        private final int blocksDug;
        private final DrillBitItem.DrillBitType bitType;

        private DigMode(String name, int blocksDug, DrillBitItem.DrillBitType bitType) {
            this.name = name;
            this.blocksDug = blocksDug;
            this.bitType = bitType;
        }

        public String getName() {
            return this.name;
        }

        public DrillBitItem.DrillBitType getBitType() {
            return this.bitType;
        }

        public int getBlocksDug() {
            return this.blocksDug;
        }

        public ResourceLocation getGuiIcon() {
            return Textures.guiIconTexture("gui_" + this.name + ".png");
        }

        public boolean atLeast(DigMode type) {
            return type.ordinal() <= this.ordinal();
        }

        public boolean isVeinMining() {
            return this == MODE_VEIN || this == MODE_VEIN_PLUS;
        }

        public boolean okToVeinMine(BlockState state) {
            return switch (this) {
                case MODE_VEIN -> state.m_204336_(PneumaticCraftTags.Blocks.JACKHAMMER_ORES);
                case MODE_VEIN_PLUS -> true;
                default -> false;
            };
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.message.jackhammer.mode." + this.name;
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            JackHammerItem jackHammer;
            Player player = event.getEntity();
            ItemStack stack = player.m_21120_(event.getHand());
            Item item = stack.m_41720_();
            if (item instanceof JackHammerItem && (float)(jackHammer = (JackHammerItem)item).getAir(stack) > 0.0f) {
                if (event.getLevel().f_46443_) {
                    MovingSounds.playMovingSound(MovingSounds.Sound.JACKHAMMER, event.getEntity(), new Object[0]);
                } else {
                    NetworkHandler.sendToAllTracking((Object)new PacketPlayMovingSound(MovingSounds.Sound.JACKHAMMER, PacketPlayMovingSound.MovingSoundFocus.of((Entity)player)), (Entity)player);
                }
            }
        }
    }
}

