/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.network;

import com.thevortex.potionsmaster.PotionsMaster;
import com.thevortex.potionsmaster.render.util.BlockStore;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class PotionPacket {
    private String potionName;

    public PotionPacket(String potion) {
        this.potionName = potion;
    }

    public static void encode(PotionPacket msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.potionName);
    }

    public static PotionPacket decode(FriendlyByteBuf buf) {
        return new PotionPacket(buf.m_130277_());
    }

    public static class Handler {
        public static void handle(PotionPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                String removed_potion = message.potionName;
                Handler.toggle(removed_potion);
            });
            ctx.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void toggle(String potion) {
            BlockStore store = PotionsMaster.blockStore;
            store.getStoreByReference(potion).getBlockData().setDrawing(false);
        }
    }
}

