/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.render.util.xray;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.thevortex.potionsmaster.render.util.BlockInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.lwjgl.opengl.GL11;

public class Render {
    @OnlyIn(value=Dist.CLIENT)
    public static final Render INSTANCE = new Render();
    private static RenderType XRAY_TYPE = null;
    private VertexBuffer vertexBuf = null;
    private final AtomicBoolean dataAvailable = new AtomicBoolean(false);
    public static OreList ores = new OreList();

    public static RenderType buildRenderType() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172757_)).m_110661_(new RenderStateShard.CullStateShard(false)).m_110685_(new RenderStateShard.TransparencyStateShard("xray", () -> {
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> RenderSystem.m_69461_())).m_110691_(true);
        return RenderType.m_173215_((String)"xray", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINES, (int)1024, (boolean)false, (boolean)false, (RenderType.CompositeState)compositeState);
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void rebuildBuffer() {
        PoseStack stack = new PoseStack();
        BufferBuilder builder = new BufferBuilder(XRAY_TYPE.m_110507_() * Render.ores.oreList.size());
        builder.m_166779_(XRAY_TYPE.m_173186_(), XRAY_TYPE.m_110508_());
        for (BlockInfo b : Render.ores.oreList) {
            if (b == null) continue;
            Render.renderShape(stack, (VertexConsumer)builder, Shapes.m_83144_(), b.m_123341_(), b.m_123342_(), b.m_123343_(), (float)b.color[0] / 255.0f, (float)b.color[1] / 255.0f, (float)b.color[2] / 255.0f, (float)b.alpha);
        }
        VertexBuffer vbuf = new VertexBuffer();
        vbuf.m_85921_();
        vbuf.m_231221_(builder.m_231175_());
        if (this.vertexBuf != null) {
            this.vertexBuf.close();
        }
        this.vertexBuf = vbuf;
        VertexBuffer.m_85931_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOres(RenderLevelStageEvent event) {
        if (XRAY_TYPE == null) {
            try {
                XRAY_TYPE = Render.buildRenderType();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.dataAvailable.get()) {
            this.rebuildBuffer();
            this.dataAvailable.set(false);
        }
        if (this.vertexBuf == null) {
            return;
        }
        Minecraft thisInstance = Minecraft.m_91087_();
        Vec3 view = thisInstance.f_91063_.m_109153_().m_90583_();
        PoseStack stack = event.getPoseStack();
        stack.m_85836_();
        stack.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        Profile.BLOCKS.apply();
        RenderSystem.m_157427_(GameRenderer::m_172757_);
        RenderSystem.m_69464_();
        RenderSystem.m_69472_();
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        this.vertexBuf.m_85921_();
        ShaderInstance thisRenderer = GameRenderer.m_172811_();
        assert (thisRenderer != null);
        thisRenderer.f_173312_.m_5985_(0.0f);
        this.vertexBuf.m_166867_(stack.m_85850_().m_85861_(), event.getProjectionMatrix().m_27658_(), thisRenderer);
        VertexBuffer.m_85931_();
        RenderSystem.m_69481_();
        RenderSystem.m_69493_();
        RenderSystem.m_69482_();
        RenderSystem.m_69458_((boolean)true);
        stack.m_85849_();
        Profile.BLOCKS.clean();
    }

    public static void renderShape(PoseStack pose, VertexConsumer vcon, VoxelShape shape, double x, double y, double z, float r, float g, float b, float a) {
        PoseStack.Pose posestack$pose = pose.m_85850_();
        shape.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            float f = (float)(x2 - x1);
            float f1 = (float)(y2 - y1);
            float f2 = (float)(z2 - z1);
            float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
            vcon.m_85982_(posestack$pose.m_85861_(), (float)(x1 + x), (float)(y1 + y), (float)(z1 + z)).m_85950_(r, g, b, a).m_85977_(posestack$pose.m_85864_(), f /= f3, f1 /= f3, f2 /= f3).m_85950_(r, g, b, a).m_5752_();
            vcon.m_85982_(posestack$pose.m_85861_(), (float)(x2 + x), (float)(y2 + y), (float)(z2 + z)).m_85950_(r, g, b, a).m_85977_(posestack$pose.m_85864_(), f, f1, f2).m_85950_(r, g, b, a).m_5752_();
        });
    }

    public static class OreList {
        protected List<BlockInfo> oreList = Collections.synchronizedList(new ArrayList());

        public void add(BlockInfo info) {
            this.oreList.add(info);
            Render.INSTANCE.dataAvailable.set(true);
        }

        public void remove(BlockInfo info) {
            this.oreList.remove((Object)info);
            Render.INSTANCE.dataAvailable.set(true);
        }

        public boolean isEmpty() {
            return this.oreList.isEmpty();
        }

        public void clear() {
            this.oreList.clear();
            Render.INSTANCE.dataAvailable.set(true);
        }

        public void addAll(Collection<? extends BlockInfo> list) {
            this.oreList.addAll(list);
            Render.INSTANCE.dataAvailable.set(true);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @OnlyIn(value=Dist.CLIENT)
    private static enum Profile {
        BLOCKS{

            @Override
            public void apply() {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)2848);
                GL11.glDisable((int)2929);
                RenderSystem.m_69832_((float)6.0f);
            }

            @Override
            public void clean() {
                GL11.glEnable((int)2929);
                GL11.glDisable((int)3042);
                GL11.glDisable((int)2848);
            }
        }
        ,
        ENTITIES{

            @Override
            public void apply() {
            }

            @Override
            public void clean() {
            }
        };


        public abstract void apply();

        public abstract void clean();
    }
}

