/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.container.AbstractContainer;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class FeederContainer
extends AbstractContainer {
    public final FeederBlockEntity tileEntity;
    private final ContainerLevelAccess canInteractWithCallable;

    public FeederContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, FeederContainer.getTileEntity(playerInventory, data));
    }

    public FeederContainer(int windowId, Inventory playerInventory, FeederBlockEntity tileEntity) {
        super((MenuType)ModContainerTypes.FEEDER.get(), windowId);
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)tileEntity.m_58904_(), (BlockPos)tileEntity.m_58899_());
        this.tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> this.addSlotBox((IItemHandler)inv, 0, 62, 35, 3, 18, 1, 18));
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static FeederBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (tileAtPos instanceof FeederBlockEntity) {
            return (FeederBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.m_39299_((world, pos) -> world.m_8055_(pos).m_60734_() instanceof Feeder && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    protected BlockEntity getTileEntity() {
        return this.tileEntity;
    }
}

