/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.refinedmods.refinedstorage.RSBlocks;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.gigabit101.rebornstorage.init.ModBlocks;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="rebornstorage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RebornStorageDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_236039_(true, (DataProvider)new GeneratorRecipes(generator));
            generator.m_236039_(true, (DataProvider)new GeneratorLoots(generator));
        }
        if (event.includeClient()) {
            generator.m_236039_(true, (DataProvider)new GeneratorBlockTags(generator, event.getExistingFileHelper()));
            generator.m_236039_(true, (DataProvider)new GeneratorLanguage(generator));
            generator.m_236039_(true, (DataProvider)new GeneratorBlockStates(generator, event.getExistingFileHelper()));
            generator.m_236039_(true, (DataProvider)new GeneratorItemModels(generator, event.getExistingFileHelper()));
        }
    }

    static class GeneratorRecipes
    extends RecipeProvider {
        public GeneratorRecipes(DataGenerator generator) {
            super(generator);
        }

        protected void m_176531_(@NotNull Consumer<FinishedRecipe> consumer) {
        }
    }

    static class GeneratorLoots
    extends LootTableProvider {
        public GeneratorLoots(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        @NotNull
        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @NotNull ValidationContext validationtracker) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private static class Blocks
        extends BlockLoot {
            private Blocks() {
            }

            protected void addTables() {
                ModBlocks.BLOCKS.getEntries().forEach(blockRegistryObject -> this.m_124165_((Block)blockRegistryObject.get(), LootTable.m_79147_().m_79161_(this.create((Block)blockRegistryObject.get()))));
            }

            public LootPool.Builder create(Block block) {
                return LootPool.m_79043_().name(this.getResourceLocation(block).toString()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
            }

            public ResourceLocation getResourceLocation(Block block) {
                return Registry.f_122824_.m_7981_((Object)block);
            }

            @NotNull
            protected Iterable<Block> getKnownBlocks() {
                return ImmutableList.of((Object)((Block)ModBlocks.BLOCK_MULTI_FRAME.get()), (Object)((Block)ModBlocks.BLOCK_MULTI_HEAT.get()), (Object)((Block)ModBlocks.BLOCK_MULTI_CPU.get()), (Object)((Block)ModBlocks.BLOCK_MULTI_STORAGE.get()), (Object)((Block)ModBlocks.BLOCK_ADVANCED_WIRELESS_TRANSMITTER.get()));
            }
        }
    }

    static class GeneratorBlockTags
    extends BlockTagsProvider {
        public GeneratorBlockTags(DataGenerator generator, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator, "rebornstorage", existingFileHelper);
        }

        protected void m_6577_() {
            ModBlocks.BLOCKS.getEntries().forEach(blockRegistryObject -> this.addMineable((Block)blockRegistryObject.get()));
            RSBlocks.COLORED_BLOCKS.forEach(registryObject -> this.addMineable((Block)registryObject.get()));
            RSBlocks.STORAGE_BLOCKS.forEach((itemStorageType, storageBlockRegistryObject) -> this.addMineable((Block)storageBlockRegistryObject.get()));
            RSBlocks.FLUID_STORAGE_BLOCKS.forEach((fluidStorageType, fluidStorageBlockRegistryObject) -> this.addMineable((Block)fluidStorageBlockRegistryObject.get()));
            this.m_206424_(BlockTags.f_144282_).m_126584_((Object[])new Block[]{(Block)RSBlocks.IMPORTER.get(), (Block)RSBlocks.EXPORTER.get(), (Block)RSBlocks.EXTERNAL_STORAGE.get(), (Block)RSBlocks.DISK_DRIVE.get(), (Block)RSBlocks.INTERFACE.get(), (Block)RSBlocks.STORAGE_MONITOR.get(), (Block)RSBlocks.FLUID_INTERFACE.get(), (Block)RSBlocks.CONSTRUCTOR.get(), (Block)RSBlocks.DESTRUCTOR.get(), (Block)RSBlocks.PORTABLE_GRID.get(), (Block)RSBlocks.CREATIVE_PORTABLE_GRID.get(), (Block)RSBlocks.CABLE.get()});
        }

        public void addMineable(Block block) {
            this.m_206424_(BlockTags.f_144282_).m_126582_((Object)block);
        }
    }

    static class GeneratorLanguage
    extends LanguageProvider {
        public GeneratorLanguage(DataGenerator gen) {
            super(gen, "rebornstorage", "en_us");
        }

        protected void addTranslations() {
        }
    }

    static class GeneratorBlockStates
    extends BlockStateProvider {
        public GeneratorBlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen, "rebornstorage", exFileHelper);
        }

        protected void registerStatesAndModels() {
        }

        public void registerSidedBlock(Block block, String folder) {
            this.horizontalBlock(block, (ModelFile)this.models().orientableWithBottom(this.getResourceLocation(block).m_135815_(), this.modLoc("block/" + folder + "/side"), this.modLoc("block/" + folder + "/front"), this.modLoc("block/" + folder + "/bottom"), this.modLoc("block/" + folder + "/top")));
        }

        public ResourceLocation getResourceLocation(Block block) {
            return Registry.f_122824_.m_7981_((Object)block);
        }
    }

    static class GeneratorItemModels
    extends ItemModelProvider {
        public GeneratorItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "rebornstorage", existingFileHelper);
        }

        protected void registerModels() {
        }

        public void registerDefaultItemBlockModel(Block block) {
            String path = this.getResourceLocation(block).m_135815_();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }

        public ResourceLocation getResourceLocation(Item item) {
            return Registry.f_122827_.m_7981_((Object)item);
        }

        public ResourceLocation getResourceLocation(Block block) {
            return Registry.f_122824_.m_7981_((Object)block);
        }

        @NotNull
        public String m_6055_() {
            return "Item Models";
        }
    }
}

