/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage.grid.monitor;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSContainerMenus;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.apiimpl.network.item.WirelessCraftingMonitorNetworkItem;
import com.refinedmods.refinedstorage.blockentity.craftingmonitor.CraftingMonitorBlockEntity;
import com.refinedmods.refinedstorage.blockentity.craftingmonitor.ICraftingMonitor;
import com.refinedmods.refinedstorage.blockentity.craftingmonitor.WirelessCraftingMonitor;
import com.refinedmods.refinedstorage.container.factory.CraftingMonitorMenuProvider;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.util.LevelUtils;
import java.util.Objects;
import net.gigabit101.rebornstorage.items.ItemWirelessGrid;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.NetworkHooks;

public class WirelessCraftingMonitorNetworkItemExt
extends WirelessCraftingMonitorNetworkItem {
    private final INetworkItemManager handler;
    private final Player player;
    private final ItemStack stack;
    private final PlayerSlot slot;

    public WirelessCraftingMonitorNetworkItemExt(INetworkItemManager handler, Player player, ItemStack stack, PlayerSlot slot) {
        super(handler, player, stack, slot);
        this.handler = handler;
        this.player = player;
        this.stack = stack;
        this.slot = slot;
    }

    public boolean onOpen(INetwork network) {
        IEnergyStorage energy = (IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (RS.SERVER_CONFIG.getWirelessCraftingMonitor().getUseEnergy() && ((ItemWirelessGrid)this.stack.m_41720_()).getType() != ItemWirelessGrid.Type.CREATIVE && energy != null && energy.getEnergyStored() <= RS.SERVER_CONFIG.getWirelessCraftingMonitor().getOpenUsage()) {
            this.sendOutOfEnergyMessage();
            return false;
        }
        if (network.getSecurityManager().hasPermission(Permission.MODIFY, this.player) && network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, this.player)) {
            WirelessCraftingMonitor wirelessCraftingMonitor = new WirelessCraftingMonitor(this.stack, this.player.m_20194_(), this.slot);
            ServerPlayer var10000 = (ServerPlayer)this.player;
            CraftingMonitorMenuProvider var10001 = new CraftingMonitorMenuProvider((MenuType)RSContainerMenus.WIRELESS_CRAFTING_MONITOR.get(), (ICraftingMonitor)wirelessCraftingMonitor, (CraftingMonitorBlockEntity)null);
            PlayerSlot var10002 = this.slot;
            Objects.requireNonNull(var10002);
            NetworkHooks.openScreen((ServerPlayer)var10000, (MenuProvider)var10001, arg_0 -> ((PlayerSlot)var10002).writePlayerSlot(arg_0));
            this.drainEnergy(RS.SERVER_CONFIG.getWirelessCraftingMonitor().getOpenUsage());
            return true;
        }
        LevelUtils.sendNoPermissionMessage((Player)this.player);
        return false;
    }

    public void drainEnergy(int energy) {
        if (RS.SERVER_CONFIG.getWirelessCraftingMonitor().getUseEnergy() && ((ItemWirelessGrid)this.stack.m_41720_()).getType() != ItemWirelessGrid.Type.CREATIVE) {
            this.stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
                energyStorage.extractEnergy(energy, false);
                if (energyStorage.getEnergyStored() <= 0) {
                    this.handler.close(this.player);
                    this.player.m_6915_();
                    this.sendOutOfEnergyMessage();
                }
            });
        }
    }

    public void sendOutOfEnergyMessage() {
        this.player.m_5661_((Component)Component.m_237110_((String)"misc.refinedstorage.network_item.out_of_energy", (Object[])new Object[]{Component.m_237115_((String)this.stack.m_41720_().m_5524_())}), false);
    }
}

