/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.entity;

import cofh.redstonearsenal.RedstoneArsenal;
import cofh.redstonearsenal.init.RSAEntities;
import cofh.redstonearsenal.item.FluxTridentItem;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class ThrownFluxTrident
extends AbstractArrow {
    protected static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownFluxTrident.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownFluxTrident.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected ItemStack tridentItem = new ItemStack((ItemLike)RedstoneArsenal.ITEMS.get("flux_trident"));
    protected boolean dealtDamage;
    public int clientSideReturnTridentTickCount;

    public ThrownFluxTrident(EntityType<? extends ThrownFluxTrident> type, Level world) {
        super(type, world);
    }

    public ThrownFluxTrident(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType)RSAEntities.FLUX_TRIDENT.get(), owner, world);
        this.tridentItem = stack.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)stack)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)stack.m_41790_());
    }

    public ThrownFluxTrident(Level world, double x, double y, double z) {
        super((EntityType)RSAEntities.FLUX_TRIDENT.get(), x, y, z, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean isEmpowered() {
        return ((FluxTridentItem)this.tridentItem.m_41720_()).isEmpowered(this.tridentItem);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_37282_();
        if ((this.dealtDamage || this.m_36797_()) && entity != null) {
            byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
            if (i > 0 && !this.isAcceptableReturnOwner()) {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else if (i > 0) {
                this.m_36790_(true);
                Vec3 vector3d = new Vec3(entity.m_20185_() - this.m_20185_(), entity.m_20188_() - this.m_20186_(), entity.m_20189_() - this.m_20189_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vector3d.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vector3d.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.m_37282_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected ItemStack m_7941_() {
        return this.tridentItem.m_41777_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 start, Vec3 end) {
        return this.dealtDamage ? null : super.m_6351_(start, end);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.m_36740_(this.m_7239_());
    }

    protected void m_5790_(EntityHitResult result) {
        BlockPos blockpos;
        Entity entity1;
        Entity entity = result.m_82443_();
        float f = 8.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.tridentItem, (MobType)livingentity.m_6336_());
        }
        DamageSource damagesource = DamageSource.m_19337_((Entity)this, (Entity)((entity1 = this.m_37282_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.m_7761_(livingentity1);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        if (this.f_19853_ instanceof ServerLevel && this.f_19853_.m_46470_() && EnchantmentHelper.m_44936_((ItemStack)this.tridentItem) && this.f_19853_.m_45527_(blockpos = entity.m_20183_())) {
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
            lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
            lightningboltentity.m_20879_(entity1 instanceof ServerPlayer ? (ServerPlayer)entity1 : null);
            this.f_19853_.m_7967_((Entity)lightningboltentity);
            soundevent = SoundEvents.f_12521_;
            f1 = 5.0f;
        }
        this.m_5496_(soundevent, f1, 1.0f);
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player player) {
        Entity entity = this.m_37282_();
        if (entity == null || entity.m_20148_() == player.m_20148_()) {
            super.m_6123_(player);
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Trident", 10)) {
            this.tridentItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Trident"));
        }
        this.dealtDamage = nbt.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.tridentItem)));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("Trident", (Tag)this.tridentItem.m_41739_(new CompoundTag()));
        nbt.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }
}

