/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.capability.CapabilityAreaEffect;
import cofh.core.config.CoreClientConfig;
import cofh.core.item.ExcavatorItem;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.AreaEffectHelper;
import cofh.lib.api.capability.IAreaEffectItem;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FluxExcavatorItem
extends ExcavatorItem
implements IMultiModeFluxItem {
    protected final float damage = this.m_41008_();
    protected final float attackSpeed;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxExcavatorItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder, int energy, int xfer) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getEnchantmentValue(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluxExcavatorItemWrapper(stack, this);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos clickPos = context.m_8083_();
        ItemStack tool = context.m_43722_();
        BlockState state = world.m_8055_(clickPos);
        Player player = context.m_43723_();
        if (player == null || !player.m_36204_(clickPos, context.m_43719_(), tool)) {
            return InteractionResult.PASS;
        }
        ImmutableList blocks = AreaEffectHelper.getPlaceableBlocksRadius((ItemStack)tool, (BlockPos)clickPos, (Player)player, (int)(1 + this.getMode(tool)));
        if (blocks.size() < 1) {
            return InteractionResult.FAIL;
        }
        if (world.f_46443_) {
            world.m_7785_((double)clickPos.m_123341_() + 0.5, (double)clickPos.m_123342_() + 0.5, (double)clickPos.m_123343_() + 0.5, state.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        } else {
            BlockPlaceContext blockContext = new BlockPlaceContext(context);
            BlockPos playerPos = player.m_20183_();
            BlockPos eyePos = new BlockPos(player.m_20299_(1.0f));
            if (player.f_36077_.f_35937_) {
                for (BlockPos pos : blocks) {
                    BlockPos fillPos = pos.m_121945_(context.m_43719_());
                    if (!world.m_8055_(fillPos).m_60629_(blockContext) || fillPos.equals((Object)playerPos) || fillPos.equals((Object)eyePos)) continue;
                    world.m_7731_(fillPos, world.m_8055_(pos).m_60734_().m_49966_(), 2);
                }
            } else if (this.hasEnergy(tool, false)) {
                HashMap sorted = new HashMap();
                for (BlockPos pos : blocks) {
                    BlockPos fillPos = pos.m_121945_(context.m_43719_());
                    if (!world.m_8055_(fillPos).m_60629_(blockContext) || fillPos.equals((Object)playerPos) || fillPos.equals((Object)eyePos)) continue;
                    Block block = world.m_8055_(pos).m_60734_();
                    sorted.putIfAbsent(block, new ArrayList());
                    ((List)sorted.get(block)).add(fillPos);
                }
                NonNullList inventory = player.f_36093_.f_35974_;
                int energyPer = this.getEnergyPerUse(false) / 2;
                int energyStored = this.getEnergyStored(tool);
                int energyUse = 0;
                for (Block block : sorted.keySet()) {
                    if (energyUse >= energyStored) break;
                    List posns = (List)sorted.get(block);
                    List validItems = Block.m_49869_((BlockState)block.m_49966_(), (ServerLevel)((ServerLevel)world), (BlockPos)((BlockPos)posns.get(0)), null).stream().map(ItemStack::m_41720_).filter(i -> i instanceof BlockItem).collect(Collectors.toList());
                    Predicate<ItemStack> matches = stack -> stack.m_41720_() instanceof BlockItem && (stack.m_41720_().equals(block.m_5456_()) || validItems.contains(stack.m_41720_()));
                    int slot = -1;
                    int uses = posns.size() - 1;
                    while (uses > 0 && (slot = FluxExcavatorItem.findFirstInventory((NonNullList<ItemStack>)inventory, matches, slot + 1)) >= 0) {
                        ItemStack stack2 = (ItemStack)inventory.get(slot);
                        BlockState place = ((BlockItem)stack2.m_41720_()).m_40614_().m_49966_();
                        int count = uses - stack2.m_41613_();
                        int consume = 0;
                        while (uses > count && uses >= 0) {
                            if (world.m_7731_((BlockPos)posns.get(uses), place, 2)) {
                                ++consume;
                                if ((energyUse += energyPer) > energyStored) break;
                            }
                            --uses;
                        }
                        stack2.m_41774_(consume);
                    }
                }
                this.useEnergy(tool, Math.min(energyUse, energyStored), false);
            }
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public static int findFirstInventory(NonNullList<ItemStack> inventory, Predicate<ItemStack> filter, int start) {
        for (int i = start; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.m_41619_() || !filter.test(stack)) continue;
            return i;
        }
        return -1;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return this.hasEnergy(stack, false) && super.canPerformAction(stack, action) && action != ToolActions.SHOVEL_FLATTEN;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useEnergy(stack, false, (Entity)attacker);
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((Level)worldIn) && state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.hasEnergy(stack, false) && (super.isCorrectToolForDrops(stack, state) || state.m_60734_().equals(Blocks.f_152499_) || state.m_204336_(BlockTags.f_13076_));
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.isCorrectToolForDrops(stack, state) ? this.f_40980_ : 1.0f;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.damage : 0.0f;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.isBarVisible(stack);
    }

    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarColor(stack);
    }

    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarWidth(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    protected class FluxExcavatorItemWrapper
    extends EnergyContainerItemWrapper
    implements IAreaEffectItem {
        private final LazyOptional<IAreaEffectItem> holder;

        FluxExcavatorItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn) {
            super(containerIn, itemIn, itemIn.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
        }

        public ImmutableList<BlockPos> getAreaEffectBlocks(BlockPos pos, Player player) {
            if (FluxExcavatorItem.this.hasEnergy(this.container, false)) {
                return AreaEffectHelper.getBreakableBlocksRadius((ItemStack)this.container, (BlockPos)pos, (Player)player, (int)(1 + FluxExcavatorItem.this.getMode(this.container) + Utils.getItemEnchantmentLevel((Enchantment)Utils.getEnchantment((String)"ensorcellation", (String)"excavating"), (ItemStack)this.container)));
            }
            return ImmutableList.of();
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY) {
                return CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

