/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.AllowedTagList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternContext;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternFactoryException;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternInputs;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternOutputs;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.InvalidCraftingPattern;
import com.refinedmods.refinedstorage.item.PatternItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.IReverseTag;

public class CraftingPatternFactory {
    public static final CraftingPatternFactory INSTANCE = new CraftingPatternFactory();

    public ICraftingPattern create(Level level, ICraftingPatternContainer container, ItemStack stack) {
        CraftingRecipe recipe;
        NonNullList fluidOutputs;
        ArrayList<NonNullList<FluidStack>> fluidInputs;
        NonNullList byproducts;
        NonNullList outputs;
        ArrayList<NonNullList<ItemStack>> inputs;
        AllowedTagList allowedTagList;
        boolean exact;
        boolean processing;
        CraftingPatternContext context;
        block9: {
            context = new CraftingPatternContext(container, stack);
            processing = PatternItem.isProcessing(stack);
            exact = PatternItem.isExact(stack);
            allowedTagList = PatternItem.getAllowedTags(stack);
            inputs = new ArrayList<NonNullList<ItemStack>>();
            outputs = NonNullList.m_122779_();
            byproducts = NonNullList.m_122779_();
            fluidInputs = new ArrayList<NonNullList<FluidStack>>();
            fluidOutputs = NonNullList.m_122779_();
            recipe = null;
            try {
                if (processing) {
                    for (int i = 0; i < 81; ++i) {
                        this.fillProcessingInputs(i, stack, inputs, (NonNullList<ItemStack>)outputs, allowedTagList);
                        this.fillProcessingFluidInputs(i, stack, fluidInputs, (NonNullList<FluidStack>)fluidOutputs, allowedTagList);
                    }
                    if (outputs.isEmpty() && fluidOutputs.isEmpty()) {
                        throw new CraftingPatternFactoryException((Component)Component.m_237115_((String)"misc.refinedstorage.pattern.error.processing_no_outputs"));
                    }
                    break block9;
                }
                CraftingPattern.DummyCraftingContainer craftingContainer = new CraftingPattern.DummyCraftingContainer();
                for (int i = 0; i < 9; ++i) {
                    this.fillCraftingInputs(craftingContainer, stack, inputs, i);
                }
                Optional foundRecipe = level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingContainer, level);
                if (foundRecipe.isPresent()) {
                    recipe = (CraftingRecipe)foundRecipe.get();
                    byproducts = recipe.m_7457_((Container)craftingContainer);
                    ItemStack output = recipe.m_5874_((Container)craftingContainer);
                    if (!output.m_41619_()) {
                        outputs.add((Object)output);
                        if (!exact) {
                            this.modifyCraftingInputsToUseAlternatives(recipe, inputs);
                        }
                        break block9;
                    }
                    throw new CraftingPatternFactoryException((Component)Component.m_237115_((String)"misc.refinedstorage.pattern.error.no_output"));
                }
                throw new CraftingPatternFactoryException((Component)Component.m_237115_((String)"misc.refinedstorage.pattern.error.recipe_does_not_exist"));
            }
            catch (CraftingPatternFactoryException e) {
                return new InvalidCraftingPattern(context, e.getErrorMessage());
            }
        }
        return new CraftingPattern(context, processing, exact, recipe, new CraftingPatternInputs(inputs, fluidInputs), new CraftingPatternOutputs((NonNullList<ItemStack>)outputs, (NonNullList<ItemStack>)byproducts, (NonNullList<FluidStack>)fluidOutputs), allowedTagList);
    }

    private void fillProcessingInputs(int i, ItemStack stack, List<NonNullList<ItemStack>> inputs, NonNullList<ItemStack> outputs, @Nullable AllowedTagList allowedTagList) throws CraftingPatternFactoryException {
        ItemStack input = PatternItem.getInputSlot(stack, i);
        if (input.m_41619_()) {
            inputs.add((NonNullList<ItemStack>)NonNullList.m_122779_());
        } else {
            NonNullList possibilities = NonNullList.m_122779_();
            possibilities.add((Object)input.m_41777_());
            if (allowedTagList != null) {
                Collection tagsOfItem = ForgeRegistries.ITEMS.tags().getReverseTag((Object)input.m_41720_()).stream().flatMap(IReverseTag::getTagKeys).map(TagKey::f_203868_).collect(Collectors.toSet());
                Set<ResourceLocation> declaredAllowedTags = allowedTagList.getAllowedItemTags().get(i);
                for (ResourceLocation declaredAllowedTag : declaredAllowedTags) {
                    if (!tagsOfItem.contains(declaredAllowedTag)) {
                        throw new CraftingPatternFactoryException((Component)Component.m_237110_((String)"misc.refinedstorage.pattern.error.tag_no_longer_applicable", (Object[])new Object[]{declaredAllowedTag.toString(), input.m_41786_()}));
                    }
                    TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)declaredAllowedTag);
                    for (Item element : ForgeRegistries.ITEMS.tags().getTag(tagKey)) {
                        possibilities.add((Object)new ItemStack((ItemLike)element, input.m_41613_()));
                    }
                }
            }
            inputs.add((NonNullList<ItemStack>)possibilities);
        }
        ItemStack output = PatternItem.getOutputSlot(stack, i);
        if (!output.m_41619_()) {
            outputs.add((Object)output);
        }
    }

    private void fillProcessingFluidInputs(int i, ItemStack stack, List<NonNullList<FluidStack>> fluidInputs, NonNullList<FluidStack> fluidOutputs, @Nullable AllowedTagList allowedTagList) throws CraftingPatternFactoryException {
        FluidStack input = PatternItem.getFluidInputSlot(stack, i);
        if (input.isEmpty()) {
            fluidInputs.add((NonNullList<FluidStack>)NonNullList.m_122779_());
        } else {
            NonNullList possibilities = NonNullList.m_122779_();
            possibilities.add((Object)input.copy());
            if (allowedTagList != null) {
                Collection tagsOfFluid = ForgeRegistries.FLUIDS.tags().getReverseTag((Object)input.getFluid()).stream().flatMap(IReverseTag::getTagKeys).map(TagKey::f_203868_).collect(Collectors.toSet());
                Set<ResourceLocation> declaredAllowedTags = allowedTagList.getAllowedFluidTags().get(i);
                for (ResourceLocation declaredAllowedTag : declaredAllowedTags) {
                    if (!tagsOfFluid.contains(declaredAllowedTag)) {
                        throw new CraftingPatternFactoryException((Component)Component.m_237110_((String)"misc.refinedstorage.pattern.error.tag_no_longer_applicable", (Object[])new Object[]{declaredAllowedTag.toString(), input.getDisplayName()}));
                    }
                    TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)declaredAllowedTag);
                    for (Fluid element : ForgeRegistries.FLUIDS.tags().getTag(tagKey)) {
                        possibilities.add((Object)new FluidStack(element, input.getAmount()));
                    }
                }
            }
            fluidInputs.add((NonNullList<FluidStack>)possibilities);
        }
        FluidStack output = PatternItem.getFluidOutputSlot(stack, i);
        if (!output.isEmpty()) {
            fluidOutputs.add((Object)output);
        }
    }

    private void fillCraftingInputs(CraftingContainer inv, ItemStack stack, List<NonNullList<ItemStack>> inputs, int i) {
        ItemStack input = PatternItem.getInputSlot(stack, i);
        inputs.add((NonNullList<ItemStack>)(input.m_41619_() ? NonNullList.m_122779_() : NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{input})));
        inv.m_6836_(i, input);
    }

    private void modifyCraftingInputsToUseAlternatives(CraftingRecipe recipe, List<NonNullList<ItemStack>> inputs) {
        if (!recipe.m_7527_().isEmpty()) {
            inputs.clear();
            for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                inputs.add(i, (NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((Ingredient)recipe.m_7527_().get(i)).m_43908_()));
            }
        }
    }
}

