/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network;

import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class FluidFilterSlotUpdateMessage {
    private final int containerSlot;
    private final FluidStack stack;

    public FluidFilterSlotUpdateMessage(int containerSlot, FluidStack stack) {
        this.containerSlot = containerSlot;
        this.stack = stack;
    }

    public static void encode(FluidFilterSlotUpdateMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.containerSlot);
        message.stack.writeToPacket(buf);
    }

    public static FluidFilterSlotUpdateMessage decode(FriendlyByteBuf buf) {
        return new FluidFilterSlotUpdateMessage(buf.readInt(), FluidStack.readFromPacket((FriendlyByteBuf)buf));
    }

    public static void handle(FluidFilterSlotUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        BaseScreen.executeLater(gui -> {
            Slot slot;
            if (message.containerSlot >= 0 && message.containerSlot < gui.m_6262_().f_38839_.size() && (slot = gui.m_6262_().m_38853_(message.containerSlot)) instanceof FluidFilterSlot) {
                ((FluidFilterSlot)slot).getFluidInventory().setFluid(slot.getSlotIndex(), message.stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

