/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network;

import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.apiimpl.network.node.SecurityManagerNetworkNode;
import com.refinedmods.refinedstorage.blockentity.SecurityManagerBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SecurityManagerUpdateMessage {
    private final BlockPos pos;
    private final Permission permission;
    private final boolean state;

    public SecurityManagerUpdateMessage(BlockPos pos, Permission permission, boolean state) {
        this.pos = pos;
        this.permission = permission;
        this.state = state;
    }

    public static SecurityManagerUpdateMessage decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int id = buf.readInt();
        Permission permission = Permission.INSERT;
        for (Permission otherPermission : Permission.values()) {
            if (otherPermission.getId() != id) continue;
            permission = otherPermission;
            break;
        }
        boolean state = buf.readBoolean();
        return new SecurityManagerUpdateMessage(pos, permission, state);
    }

    public static void encode(SecurityManagerUpdateMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeInt(message.permission.getId());
        buf.writeBoolean(message.state);
    }

    public static void handle(SecurityManagerUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> SecurityManagerUpdateMessage.lambda$handle$0((Player)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(Player player, SecurityManagerUpdateMessage message) {
        BlockEntity blockEntity = player.m_20193_().m_7702_(message.pos);
        if (blockEntity instanceof SecurityManagerBlockEntity) {
            ((SecurityManagerNetworkNode)((SecurityManagerBlockEntity)blockEntity).getNode()).updatePermission(message.permission, message.state);
        }
    }
}

