/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.apiimpl.network.Network;
import com.refinedmods.refinedstorage.blockentity.ClientNode;
import com.refinedmods.refinedstorage.blockentity.ControllerBlockEntity;
import com.refinedmods.refinedstorage.container.ControllerContainerMenu;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ControllerScreen
extends BaseScreen<ControllerContainerMenu> {
    private static final int VISIBLE_ROWS = 2;
    private static final int ENERGY_BAR_X = 8;
    private static final int ENERGY_BAR_Y = 20;
    private static final int ENERGY_BAR_WIDTH = 16;
    private static final int ENERGY_BAR_HEIGHT = 59;
    private final ScrollbarWidget scrollbar = new ScrollbarWidget(this, 157, 20, 12, 59);

    public ControllerScreen(ControllerContainerMenu containerMenu, Inventory inventory, Component title) {
        super(containerMenu, 176, 181, inventory, title);
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addSideButton(new RedstoneModeSideButton(this, ControllerBlockEntity.REDSTONE_MODE));
    }

    @Override
    public void tick(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() > 2);
        this.scrollbar.setMaxOffset(this.getRows() - 2);
    }

    @Override
    public void renderBackground(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/controller.png");
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        int energyBarHeightNew = Network.getEnergyScaled(ControllerBlockEntity.ENERGY_STORED.getValue(), ControllerBlockEntity.ENERGY_CAPACITY.getValue(), 59);
        this.m_93228_(poseStack, x + 8, y + 20 + 59 - energyBarHeightNew, 178, 59 - energyBarHeightNew, 16, energyBarHeightNew);
        this.scrollbar.render(poseStack);
    }

    public void m_94757_(double mx, double my) {
        this.scrollbar.m_94757_(mx, my);
        super.m_94757_(mx, my);
    }

    public boolean m_6375_(double mx, double my, int button) {
        return this.scrollbar.m_6375_(mx, my, button) || super.m_6375_(mx, my, button);
    }

    public boolean m_6348_(double mx, double my, int button) {
        return this.scrollbar.m_6348_(mx, my, button) || super.m_6348_(mx, my, button);
    }

    public boolean m_6050_(double x, double y, double delta) {
        return this.scrollbar.m_6050_(x, y, delta) || super.m_6050_(x, y, delta);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        this.renderString(poseStack, 7, 7, this.f_96539_.getString());
        this.renderString(poseStack, 7, 87, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
        int x = 33;
        int y = 26;
        int slot = this.scrollbar.getOffset() * 2;
        Lighting.m_84931_();
        List<ClientNode> nodes = ControllerBlockEntity.NODES.getValue();
        ClientNode hoveringNode = null;
        for (int i = 0; i < 4; ++i) {
            if (slot < nodes.size()) {
                ClientNode node = nodes.get(slot);
                this.renderItem(poseStack, x, y + 5, node.getStack());
                float scale = this.f_96541_.m_91390_() ? 1.0f : 0.5f;
                poseStack.m_85836_();
                poseStack.m_85841_(scale, scale, 1.0f);
                this.renderString(poseStack, RenderUtils.getOffsetOnScale(x + 1, scale), RenderUtils.getOffsetOnScale(y - 2, scale), this.trimNameIfNeeded(!this.f_96541_.m_91390_(), node.getStack().m_41786_().getString()));
                this.renderString(poseStack, RenderUtils.getOffsetOnScale(x + 21, scale), RenderUtils.getOffsetOnScale(y + 10, scale), node.getAmount() + "x");
                poseStack.m_85849_();
                if (RenderUtils.inBounds(x, y, 16, 16, mouseX, mouseY)) {
                    hoveringNode = node;
                }
            }
            if (i == 1) {
                x = 33;
                y += 30;
            } else {
                x += 60;
            }
            ++slot;
        }
        if (hoveringNode != null) {
            this.renderTooltip(poseStack, mouseX, mouseY, I18n.m_118938_((String)"misc.refinedstorage.energy_usage_minimal", (Object[])new Object[]{hoveringNode.getEnergyUsage()}));
        }
        if (RenderUtils.inBounds(8, 20, 16, 59, mouseX, mouseY)) {
            this.renderTooltip(poseStack, mouseX, mouseY, I18n.m_118938_((String)"misc.refinedstorage.energy_usage", (Object[])new Object[]{ControllerBlockEntity.ENERGY_USAGE.getValue()}) + "\n" + I18n.m_118938_((String)"misc.refinedstorage.energy_stored", (Object[])new Object[]{ControllerBlockEntity.ENERGY_STORED.getValue(), ControllerBlockEntity.ENERGY_CAPACITY.getValue()}));
        }
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)ControllerBlockEntity.NODES.getValue().size() / 2.0f));
    }

    private String trimNameIfNeeded(boolean scaled, String name) {
        int max;
        int n = max = scaled ? 20 : 13;
        if (((String)name).length() > max) {
            name = ((String)name).substring(0, max) + "...";
        }
        return name;
    }
}

