/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.blocks.PassivePedestalBlock;
import reliquary.blocks.tile.PedestalBlockEntity;
import reliquary.init.ModBlocks;
import reliquary.pedestal.PedestalRegistry;
import reliquary.reference.Settings;
import reliquary.util.BlockEntityHelper;
import reliquary.util.WorldHelper;

public class PedestalBlock
extends PassivePedestalBlock {
    public static final BooleanProperty ENABLED = BooleanProperty.m_61465_((String)"enabled");
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.m_49796_((double)3.5, (double)9.0, (double)12.0, (double)12.5, (double)10.0, (double)12.5), Block.m_49796_((double)3.5, (double)9.0, (double)3.5, (double)12.5, (double)10.0, (double)4.0), Block.m_49796_((double)12.0, (double)9.0, (double)4.0, (double)12.5, (double)10.0, (double)12.0), Block.m_49796_((double)3.5, (double)9.0, (double)4.0, (double)4.0, (double)10.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public PedestalBlock() {
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ENABLED});
    }

    @Override
    protected boolean isDisabled() {
        return Boolean.TRUE.equals(Settings.COMMON.disable.disablePedestal.get());
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(level.m_46472_().m_211136_(), pos, 160);
        for (BlockPos pedestalPosition : pedestalPositions) {
            WorldHelper.getBlockEntity((BlockGetter)level, pedestalPosition, PedestalBlockEntity.class).ifPresent(pedestalBlockEntity -> pedestalBlockEntity.updateRedstone(level));
        }
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PedestalBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            return null;
        }
        return BlockEntityHelper.createTickerHelper(blockEntityType, (BlockEntityType)ModBlocks.PEDESTAL_TILE_TYPE.get(), (l, p, s, be) -> be.serverTick(l));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
        ((PedestalBlockEntity)level.m_7702_(pos)).neighborUpdate(level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (Boolean.TRUE.equals(state.m_61143_((Property)ENABLED)) && rand.m_188503_(2) == 1) {
            Direction dir = Direction.m_122407_((int)rand.m_188503_(4));
            double xMiddle = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.0625 + rand.m_188500_() * 4.0 / 16.0;
            double zMiddle = (double)pos.m_123343_() + 0.5;
            double sideOffset = 0.25 + rand.m_188500_() * 2.0 / 16.0;
            double alongTheSideOffset = rand.m_188500_() * 6.0 / 16.0;
            Vec3i normal = dir.m_122436_();
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, xMiddle + (double)normal.m_123341_() * sideOffset + (double)normal.m_123343_() * alongTheSideOffset, y, zMiddle + (double)normal.m_123343_() * sideOffset + (double)normal.m_123341_() * alongTheSideOffset, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (level.f_46443_) {
            return !heldItem.m_41619_() || player.m_6047_() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, pos, PedestalBlockEntity.class).map(pedestal -> {
            if (heldItem.m_41619_() && !player.m_6047_() && hand == InteractionHand.MAIN_HAND && this.switchClicked(hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) {
                pedestal.toggleSwitch(level);
                return InteractionResult.SUCCESS;
            }
            return super.m_6227_(state, level, pos, player, hand, hit);
        }).orElse(InteractionResult.FAIL);
    }

    private boolean switchClicked(Vec3 hitVec) {
        double xOff = hitVec.m_7096_();
        double yOff = hitVec.m_7098_();
        double zOff = hitVec.m_7094_();
        return yOff >= 0.0625 && yOff <= 0.25 && xOff >= 0.25 && xOff <= 0.75 && zOff >= 0.25 && zOff <= 0.75;
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() == this) {
            return;
        }
        PedestalRegistry.unregisterPosition(level.m_46472_().m_211136_(), pos);
        WorldHelper.getBlockEntity((BlockGetter)level, pos, PedestalBlockEntity.class).ifPresent(pedestal -> pedestal.removeAndSpawnItem(level));
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

